/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.ConfigurationModule;

public class CompoundModule
implements ConfigurationModule {
    private final ConfigurationType type;
    private final List<ConfigurationModule> modules;

    public CompoundModule(ConfigurationType type, Collection<ConfigurationModule> modules) {
        this.type = type;
        this.modules = List.copyOf(modules);
    }

    public ConfigurationType type() {
        return this.type;
    }

    public Collection<RootKey<?, ?>> rootKeys() {
        return this.unionFromModulesExtractedWith(ConfigurationModule::rootKeys);
    }

    private <T> List<T> unionFromModulesExtractedWith(Function<? super ConfigurationModule, ? extends Collection<T>> extractor) {
        return this.modules.stream().flatMap(module -> ((Collection)extractor.apply((ConfigurationModule)module)).stream()).collect(Collectors.toUnmodifiableList());
    }

    public Map<Class<? extends Annotation>, Set<Validator<? extends Annotation, ?>>> validators() {
        Map result = this.modules.stream().flatMap(module -> module.validators().entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.flatMapping(e -> ((Set)e.getValue()).stream(), Collectors.toUnmodifiableSet())));
        return Collections.unmodifiableMap(result);
    }

    public Collection<Class<?>> internalSchemaExtensions() {
        return this.unionFromModulesExtractedWith(ConfigurationModule::internalSchemaExtensions);
    }

    public Collection<Class<?>> polymorphicSchemaExtensions() {
        return this.unionFromModulesExtractedWith(ConfigurationModule::polymorphicSchemaExtensions);
    }
}

