/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.marshaller.MarshallerWriter;

public class ClientMarshallerWriter
implements MarshallerWriter {
    private final BinaryTupleBuilder packer;
    private final BitSet noValueSet;

    public ClientMarshallerWriter(BinaryTupleBuilder packer, BitSet noValueSet) {
        this.packer = packer;
        this.noValueSet = noValueSet;
    }

    public void writeNull() {
        this.packer.appendNull();
    }

    public void writeAbsentValue() {
        this.noValueSet.set(this.packer.elementIndex());
        this.packer.appendDefault();
    }

    public void writeByte(byte val) {
        this.packer.appendByte(val);
    }

    public void writeShort(short val) {
        this.packer.appendShort(val);
    }

    public void writeInt(int val) {
        this.packer.appendInt(val);
    }

    public void writeLong(long val) {
        this.packer.appendLong(val);
    }

    public void writeFloat(float val) {
        this.packer.appendFloat(val);
    }

    public void writeDouble(double val) {
        this.packer.appendDouble(val);
    }

    public void writeString(String val) {
        this.packer.appendString(val);
    }

    public void writeUuid(UUID val) {
        this.packer.appendUuid(val);
    }

    public void writeBytes(byte[] val) {
        this.packer.appendBytes(val);
    }

    public void writeBitSet(BitSet val) {
        this.packer.appendBitmask(val);
    }

    public void writeBigInt(BigInteger val) {
        this.packer.appendNumber(val);
    }

    public void writeBigDecimal(BigDecimal val, int scale) {
        this.packer.appendDecimal(val, scale);
    }

    public void writeDate(LocalDate val) {
        this.packer.appendDate(val);
    }

    public void writeTime(LocalTime val) {
        this.packer.appendTime(val);
    }

    public void writeTimestamp(Instant val) {
        this.packer.appendTimestamp(val);
    }

    public void writeDateTime(LocalDateTime val) {
        this.packer.appendDateTime(val);
    }
}

