/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.future;

import java.util.ArrayDeque;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class OrderingFuture<T> {
    private static final AtomicReferenceFieldUpdater<OrderingFuture, State> STATE = AtomicReferenceFieldUpdater.newUpdater(OrderingFuture.class, State.class, "state");
    private volatile State<T> state = State.empty();
    private final AtomicBoolean completionStarted = new AtomicBoolean(false);
    private final CountDownLatch completionValuesReadyLatch = new CountDownLatch(1);

    public static <T> OrderingFuture<T> completedFuture(@Nullable T result) {
        OrderingFuture<T> future = new OrderingFuture<T>();
        future.complete(result);
        return future;
    }

    public static <T> OrderingFuture<T> failedFuture(Throwable ex) {
        OrderingFuture<T> future = new OrderingFuture<T>();
        future.completeExceptionally(ex);
        return future;
    }

    public static <T> OrderingFuture<T> adapt(CompletableFuture<T> adaptee) {
        OrderingFuture future = new OrderingFuture();
        adaptee.whenComplete((T res, U ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            } else {
                future.complete(res);
            }
        });
        return future;
    }

    public void complete(@Nullable T result) {
        this.completeInternal(result, null);
    }

    public void completeExceptionally(Throwable ex) {
        this.completeInternal(null, ex);
    }

    private void completeInternal(@Nullable T result, @Nullable Throwable ex) {
        assert (ex == null || result == null);
        if (!this.completionStarted.compareAndSet(false, true)) {
            this.waitForCompletionValuesVisibility();
            return;
        }
        assert (this.state.phase == Phase.INCOMPLETE);
        this.switchToNotifyingStage(result, ex);
        assert (this.state.phase == Phase.NOTIFYING);
        this.completionValuesReadyLatch.countDown();
        this.completeNotificationStage(result, ex);
        assert (this.state.phase == Phase.COMPLETED);
    }

    private void waitForCompletionValuesVisibility() {
        try {
            this.completionValuesReadyLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void switchToNotifyingStage(@Nullable T result, @Nullable Throwable ex) {
        State<T> newState;
        State<T> prevState;
        while (!this.replaceState(prevState = this.state, newState = prevState.switchToNotifying(result, ex))) {
        }
    }

    private void completeNotificationStage(@Nullable T result, @Nullable Throwable ex) {
        State<T> newState;
        State<T> prevState;
        ListNode lastNotifiedNode = null;
        do {
            prevState = this.state;
            newState = prevState.switchToCompleted();
            this.notifyDependents(result, ex, prevState.dependentsQueueTail, lastNotifiedNode);
            lastNotifiedNode = prevState.dependentsQueueTail;
        } while (!this.replaceState(prevState, newState));
    }

    private boolean replaceState(State<T> prevState, State<T> newState) {
        return STATE.compareAndSet(this, prevState, newState);
    }

    private void notifyDependents(@Nullable T result, @Nullable Throwable ex, @Nullable ListNode<T> dependents, ListNode<T> lastNotifiedNode) {
        if (dependents != null) {
            dependents.notifyHeadToTail(result, ex, lastNotifiedNode);
        }
    }

    public boolean isCompletedExceptionally() {
        return this.state.exception != null;
    }

    public void whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        State<T> newState;
        State<? super T> prevState;
        WhenComplete<? super T> dependent = null;
        do {
            if ((prevState = this.state).completionQueueProcessed()) {
                OrderingFuture.acceptQuietly(action, prevState.result, prevState.exception);
                return;
            }
            if (dependent != null) continue;
            dependent = new WhenComplete<T>(action);
        } while (!this.replaceState(prevState, newState = prevState.enqueueDependent(dependent)));
    }

    private static <T> void acceptQuietly(BiConsumer<? super T, ? super Throwable> action, T result, Throwable ex) {
        try {
            action.accept(result, ex);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <U> CompletableFuture<U> thenComposeToCompletable(Function<? super T, ? extends CompletableFuture<U>> mapper) {
        State<T> newState;
        State<T> prevState;
        ThenComposeToCompletable dependent = null;
        do {
            if ((prevState = this.state).completionQueueProcessed()) {
                if (prevState.exception != null) {
                    return CompletableFuture.failedFuture(OrderingFuture.wrapWithCompletionException(prevState.exception));
                }
                return OrderingFuture.applyMapper(mapper, prevState.result);
            }
            if (dependent != null) continue;
            dependent = new ThenComposeToCompletable(new CompletableFuture(), mapper);
        } while (!this.replaceState(prevState, newState = prevState.enqueueDependent(dependent)));
        return dependent.resultFuture;
    }

    private static CompletionException wrapWithCompletionException(Throwable ex) {
        return ex instanceof CompletionException ? (CompletionException)ex : new CompletionException(ex);
    }

    private static <T, U> CompletableFuture<U> applyMapper(Function<? super T, ? extends CompletableFuture<U>> mapper, T result) {
        try {
            return mapper.apply(result);
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public T getNow(T valueIfAbsent) {
        State<T> currentState = this.state;
        if (currentState.completionValuesAvailable()) {
            if (currentState.exception != null) {
                throw OrderingFuture.wrapWithCompletionException(currentState.exception);
            }
            return currentState.result;
        }
        return valueIfAbsent;
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        boolean completedInTime = this.completionValuesReadyLatch.await(timeout, unit);
        if (!completedInTime) {
            throw new TimeoutException();
        }
        State<T> currentState = this.state;
        if (currentState.exception instanceof CancellationException) {
            throw (CancellationException)currentState.exception;
        }
        if (currentState.exception != null) {
            throw this.exceptionForThrowingFromGet(currentState);
        }
        return currentState.result;
    }

    private ExecutionException exceptionForThrowingFromGet(State<T> currentState) {
        Throwable unwrapped = currentState.exception;
        Throwable cause = unwrapped.getCause();
        if (cause != null) {
            unwrapped = cause;
        }
        return new ExecutionException(unwrapped);
    }

    public CompletableFuture<T> toCompletableFuture() {
        CompletableFuture completableFuture = new CompletableFuture();
        this.whenComplete((res, ex) -> OrderingFuture.completeCompletableFuture(completableFuture, res, ex));
        return completableFuture;
    }

    private static <T> void completeCompletableFuture(CompletableFuture<T> future, T result, Throwable ex) {
        if (ex != null) {
            future.completeExceptionally(ex);
        } else {
            future.complete(result);
        }
    }

    private static enum Phase {
        INCOMPLETE,
        NOTIFYING,
        COMPLETED;

    }

    private static class ListNode<T> {
        private final DependentAction<T> dependent;
        private final ListNode<T> next;

        private ListNode(DependentAction<T> dependent, ListNode<T> next) {
            this.dependent = dependent;
            this.next = next;
        }

        public void notifyHeadToTail(T result, Throwable exception, ListNode<T> lastNotifiedNode) {
            ArrayDeque<ListNode<T>> stack = new ArrayDeque<ListNode<T>>();
            ListNode<T> node = this;
            while (node != null && node != lastNotifiedNode) {
                stack.addFirst(node);
                node = node.next;
            }
            while (!stack.isEmpty()) {
                node = (ListNode)stack.removeFirst();
                try {
                    node.dependent.onCompletion(result, exception);
                }
                catch (Exception exception2) {}
            }
        }
    }

    private static class State<T> {
        private static final State<?> INCOMPLETE_STATE = new State<Object>(Phase.INCOMPLETE, null, null, null);
        private final Phase phase;
        private final T result;
        private final Throwable exception;
        private final ListNode<T> dependentsQueueTail;

        private State(Phase phase, T result, Throwable exception, ListNode<T> dependentsQueueTail) {
            this.phase = phase;
            this.result = result;
            this.exception = exception;
            this.dependentsQueueTail = dependentsQueueTail;
        }

        private static <T> State<T> empty() {
            return INCOMPLETE_STATE;
        }

        public boolean completionValuesAvailable() {
            return this.phase != Phase.INCOMPLETE;
        }

        public boolean completionQueueProcessed() {
            return this.phase == Phase.COMPLETED;
        }

        public State<T> switchToNotifying(T completionResult, Throwable completionCause) {
            return new State<T>(Phase.NOTIFYING, completionResult, completionCause, this.dependentsQueueTail);
        }

        public State<T> switchToCompleted() {
            return new State<T>(Phase.COMPLETED, this.result, this.exception, null);
        }

        public State<T> enqueueDependent(DependentAction<T> dependent) {
            return new State<T>(this.phase, this.result, this.exception, new ListNode<T>(dependent, this.dependentsQueueTail));
        }
    }

    private static class ThenComposeToCompletable<T, U>
    implements DependentAction<T> {
        private final CompletableFuture<U> resultFuture;
        private final Function<? super T, ? extends CompletableFuture<U>> mapper;

        private ThenComposeToCompletable(CompletableFuture<U> resultFuture, Function<? super T, ? extends CompletableFuture<U>> mapper) {
            this.resultFuture = resultFuture;
            this.mapper = mapper;
        }

        @Override
        public void onCompletion(T result, Throwable ex) {
            if (ex != null) {
                this.resultFuture.completeExceptionally(OrderingFuture.wrapWithCompletionException(ex));
                return;
            }
            try {
                CompletableFuture<U> mapResult = this.mapper.apply(result);
                mapResult.whenComplete((mapRes, mapEx) -> OrderingFuture.completeCompletableFuture(this.resultFuture, mapRes, mapEx));
            }
            catch (Throwable e) {
                this.resultFuture.completeExceptionally(e);
            }
        }
    }

    private static class WhenComplete<T>
    implements DependentAction<T> {
        private final BiConsumer<? super T, ? super Throwable> action;

        private WhenComplete(BiConsumer<? super T, ? super Throwable> action) {
            this.action = action;
        }

        @Override
        public void onCompletion(T result, Throwable ex) {
            OrderingFuture.acceptQuietly(this.action, result, ex);
        }
    }

    private static interface DependentAction<T> {
        public void onCompletion(T var1, Throwable var2);
    }
}

