/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.io.IOException;
import java.util.UUID;
import org.apache.ignite.internal.network.ClusterNodeImpl;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NodeMetadata;

public class ClusterNodeSerializer
extends VersionedSerializer<ClusterNode> {
    public static final ClusterNodeSerializer INSTANCE = new ClusterNodeSerializer();

    protected void writeExternalData(ClusterNode node, IgniteDataOutput out) throws IOException {
        out.writeUuid(node.id());
        out.writeUTF(node.name());
        out.writeUTF(node.address().host());
        out.writeVarInt((long)node.address().port());
        NodeMetadata metadata = node.nodeMetadata();
        out.writeBoolean(metadata != null);
        if (metadata != null) {
            out.writeUTF(metadata.restHost());
            out.writeVarInt((long)metadata.httpPort());
            out.writeVarInt((long)metadata.httpsPort());
        }
    }

    protected ClusterNode readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        UUID id = in.readUuid();
        String name = in.readUTF();
        NetworkAddress address = new NetworkAddress(in.readUTF(), in.readVarIntAsInt());
        boolean hasMetadata = in.readBoolean();
        NodeMetadata metadata = hasMetadata ? new NodeMetadata(in.readUTF(), in.readVarIntAsInt(), in.readVarIntAsInt()) : null;
        return new ClusterNodeImpl(id, name, address, metadata);
    }
}

