/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.configuration.ConfigurationModule;
import org.apache.ignite.configuration.SuperRootChange;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.internal.configuration.MetaStorageView;
import org.apache.ignite.internal.configuration.SystemDistributedExtensionChange;
import org.apache.ignite.internal.configuration.SystemDistributedExtensionConfiguration;
import org.apache.ignite.internal.configuration.SystemDistributedExtensionConfigurationSchema;
import org.apache.ignite.internal.configuration.SystemDistributedExtensionView;

@AutoService(value={ConfigurationModule.class})
public class SystemDistributedConfigurationModule
implements ConfigurationModule {
    public ConfigurationType type() {
        return ConfigurationType.DISTRIBUTED;
    }

    public Collection<Class<?>> schemaExtensions() {
        return List.of(SystemDistributedExtensionConfigurationSchema.class);
    }

    public void migrateDeprecatedConfigurations(SuperRootChange superRootChange) {
        SystemDistributedExtensionView rootView = (SystemDistributedExtensionView)superRootChange.viewRoot(SystemDistributedExtensionConfiguration.KEY);
        SystemDistributedExtensionChange rootChange = (SystemDistributedExtensionChange)superRootChange.changeRoot(SystemDistributedExtensionConfiguration.KEY);
        MetaStorageView metaStorageView = rootView.metaStorage();
        if (metaStorageView.idleSyncTimeInterval() != 250L) {
            rootChange.changeSystem().changeIdleSafeTimeSyncIntervalMillis(metaStorageView.idleSyncTimeInterval());
        }
    }
}

