/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.raft.jraft.util.ExecutorServiceHelper;
import org.apache.ignite.raft.jraft.util.ThreadPoolUtil;
import org.apache.ignite.raft.jraft.util.concurrent.SingleThreadExecutor;

public final class DefaultSingleThreadExecutor
implements SingleThreadExecutor {
    private static final IgniteLogger LOG = Loggers.forClass(DefaultSingleThreadExecutor.class);
    private final SingleThreadExecutor singleThreadExecutor;

    public DefaultSingleThreadExecutor(ExecutorService singleThreadExecutorService) {
        this.singleThreadExecutor = DefaultSingleThreadExecutor.wrapSingleThreadExecutor(singleThreadExecutorService);
    }

    public DefaultSingleThreadExecutor(String poolName, int maxPendingTasks) {
        this.singleThreadExecutor = DefaultSingleThreadExecutor.createSingleThreadExecutor(poolName, maxPendingTasks);
    }

    @Override
    public void execute(Runnable task) {
        this.singleThreadExecutor.execute(task);
    }

    @Override
    public boolean shutdownGracefully() {
        return this.singleThreadExecutor.shutdownGracefully();
    }

    @Override
    public boolean shutdownGracefully(long timeout, TimeUnit unit) {
        return this.singleThreadExecutor.shutdownGracefully(timeout, unit);
    }

    private static SingleThreadExecutor wrapSingleThreadExecutor(final ExecutorService executor) {
        if (executor instanceof SingleThreadExecutor) {
            return (SingleThreadExecutor)((Object)executor);
        }
        return new SingleThreadExecutor(){

            @Override
            public boolean shutdownGracefully() {
                return ExecutorServiceHelper.shutdownAndAwaitTermination(executor);
            }

            @Override
            public boolean shutdownGracefully(long timeout, TimeUnit unit) {
                return ExecutorServiceHelper.shutdownAndAwaitTermination(executor, unit.toMillis(timeout));
            }

            @Override
            public void execute(Runnable command) {
                executor.execute(command);
            }
        };
    }

    private static SingleThreadExecutor createSingleThreadExecutor(String poolName, int maxPendingTasks) {
        final ThreadPoolExecutor singleThreadPool = ThreadPoolUtil.newBuilder().poolName(poolName).enableMetric(true).coreThreads(1).maximumThreads(1).keepAliveSeconds(60L).workQueue(new LinkedBlockingQueue<Runnable>(maxPendingTasks)).threadFactory((ThreadFactory)IgniteThreadFactory.createWithFixedPrefix((String)poolName, (boolean)true, (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0])).build();
        return new SingleThreadExecutor(){

            @Override
            public boolean shutdownGracefully() {
                return ExecutorServiceHelper.shutdownAndAwaitTermination(singleThreadPool);
            }

            @Override
            public boolean shutdownGracefully(long timeout, TimeUnit unit) {
                return ExecutorServiceHelper.shutdownAndAwaitTermination(singleThreadPool, unit.toMillis(timeout));
            }

            @Override
            public void execute(Runnable command) {
                singleThreadPool.execute(command);
            }
        };
    }
}

