/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.criteria;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

public class SqlRowProjection
implements Tuple {
    private final SqlRow row;
    private final Object2IntMap<String> columnsIndices;
    private final int[] rowIndexMapping;

    public SqlRowProjection(SqlRow row, ResultSetMetadata meta, String[] cols) {
        this.row = row;
        this.rowIndexMapping = new int[cols.length];
        this.columnsIndices = new Object2IntOpenHashMap(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            String quotedColumnName = IgniteNameUtils.quoteIfNeeded((String)cols[i]);
            this.columnsIndices.put((Object)quotedColumnName, i);
            this.rowIndexMapping[i] = meta.indexOf(quotedColumnName);
        }
    }

    public int columnCount() {
        return this.rowIndexMapping.length;
    }

    public String columnName(int columnIndex) {
        return this.row.columnName(this.rowIndexMapping[columnIndex]);
    }

    public int columnIndex(String columnName) {
        return this.columnsIndices.getOrDefault((Object)columnName, -1);
    }

    @Nullable
    public <T> T valueOrDefault(String columnName, @Nullable T defaultValue) {
        return (T)this.row.valueOrDefault(columnName, defaultValue);
    }

    public Tuple set(String columnName, @Nullable Object value) {
        return this.row.set(columnName, value);
    }

    @Nullable
    public <T> T value(String columnName) throws IllegalArgumentException {
        return (T)this.row.value(columnName);
    }

    @Nullable
    public <T> T value(int columnIndex) {
        return (T)this.row.value(this.rowIndexMapping[columnIndex]);
    }

    public boolean booleanValue(String columnName) {
        return this.row.booleanValue(columnName);
    }

    public boolean booleanValue(int columnIndex) {
        return this.row.booleanValue(this.rowIndexMapping[columnIndex]);
    }

    public byte byteValue(String columnName) {
        return this.row.byteValue(columnName);
    }

    public byte byteValue(int columnIndex) {
        return this.row.byteValue(this.rowIndexMapping[columnIndex]);
    }

    public short shortValue(String columnName) {
        return this.row.shortValue(columnName);
    }

    public short shortValue(int columnIndex) {
        return this.row.shortValue(this.rowIndexMapping[columnIndex]);
    }

    public int intValue(String columnName) {
        return this.row.intValue(columnName);
    }

    public int intValue(int columnIndex) {
        return this.row.intValue(this.rowIndexMapping[columnIndex]);
    }

    public long longValue(String columnName) {
        return this.row.longValue(columnName);
    }

    public long longValue(int columnIndex) {
        return this.row.longValue(this.rowIndexMapping[columnIndex]);
    }

    public float floatValue(String columnName) {
        return this.row.floatValue(columnName);
    }

    public float floatValue(int columnIndex) {
        return this.row.floatValue(this.rowIndexMapping[columnIndex]);
    }

    public double doubleValue(String columnName) {
        return this.row.doubleValue(columnName);
    }

    public double doubleValue(int columnIndex) {
        return this.row.doubleValue(this.rowIndexMapping[columnIndex]);
    }

    public BigDecimal decimalValue(String columnName) {
        return this.row.decimalValue(columnName);
    }

    public BigDecimal decimalValue(int columnIndex) {
        return this.row.decimalValue(this.rowIndexMapping[columnIndex]);
    }

    public String stringValue(String columnName) {
        return this.row.stringValue(columnName);
    }

    public String stringValue(int columnIndex) {
        return this.row.stringValue(this.rowIndexMapping[columnIndex]);
    }

    public byte[] bytesValue(String columnName) {
        return this.row.bytesValue(columnName);
    }

    public byte[] bytesValue(int columnIndex) {
        return this.row.bytesValue(this.rowIndexMapping[columnIndex]);
    }

    public UUID uuidValue(String columnName) {
        return this.row.uuidValue(columnName);
    }

    public UUID uuidValue(int columnIndex) {
        return this.row.uuidValue(this.rowIndexMapping[columnIndex]);
    }

    public LocalDate dateValue(String columnName) {
        return this.row.dateValue(columnName);
    }

    public LocalDate dateValue(int columnIndex) {
        return this.row.dateValue(this.rowIndexMapping[columnIndex]);
    }

    public LocalTime timeValue(String columnName) {
        return this.row.timeValue(columnName);
    }

    public LocalTime timeValue(int columnIndex) {
        return this.row.timeValue(this.rowIndexMapping[columnIndex]);
    }

    public LocalDateTime datetimeValue(String columnName) {
        return this.row.datetimeValue(columnName);
    }

    public LocalDateTime datetimeValue(int columnIndex) {
        return this.row.datetimeValue(this.rowIndexMapping[columnIndex]);
    }

    public Instant timestampValue(String columnName) {
        return this.row.timestampValue(columnName);
    }

    public Instant timestampValue(int columnIndex) {
        return this.row.timestampValue(this.rowIndexMapping[columnIndex]);
    }
}

