/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.ddl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogApplyResult;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.commands.AbstractCreateIndexCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.MakeIndexAvailableEventParameters;
import org.apache.ignite.internal.catalog.events.RemoveIndexEventParameters;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.future.InFlightFutures;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.sql.engine.exec.LifecycleAware;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;

public class DdlCommandHandler
implements LifecycleAware {
    private final CatalogManager catalogManager;
    private final ClockService clockService;
    private final InFlightFutures inFlightFutures = new InFlightFutures();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();

    public DdlCommandHandler(CatalogManager catalogManager, ClockService clockService) {
        this.catalogManager = catalogManager;
        this.clockService = clockService;
    }

    public CompletableFuture<CatalogApplyResult> handle(List<CatalogCommand> batch) {
        CompletableFuture fut = this.catalogManager.execute(batch);
        boolean hasCreateIndexCommand = batch.stream().anyMatch(AbstractCreateIndexCommand.class::isInstance);
        if (!hasCreateIndexCommand) {
            return fut;
        }
        return fut.thenCompose(applyResult -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            ArrayList<CompletableFuture<CatalogApplyResult>> toWait = new ArrayList<CompletableFuture<CatalogApplyResult>>();
            for (int i = 0; i < batch.size(); ++i) {
                CatalogCommand cmd = (CatalogCommand)batch.get(i);
                if (!(cmd instanceof AbstractCreateIndexCommand) || !applyResult.isApplied(i)) continue;
                toWait.add(this.waitTillIndexBecomesAvailableOrRemoved((AbstractCreateIndexCommand)cmd, i, (CatalogApplyResult)applyResult));
            }
            return CompletableFutures.allOf(toWait).thenApply(none -> applyResult);
        }));
    }

    public CompletableFuture<CatalogApplyResult> handle(CatalogCommand cmd) {
        CompletionStage fut = this.catalogManager.execute(cmd);
        if (cmd instanceof AbstractCreateIndexCommand) {
            fut = fut.thenCompose(applyResult -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.waitTillIndexBecomesAvailableOrRemoved((AbstractCreateIndexCommand)cmd, 0, (CatalogApplyResult)applyResult)));
        }
        return fut;
    }

    private CompletableFuture<CatalogApplyResult> waitTillIndexBecomesAvailableOrRemoved(AbstractCreateIndexCommand cmd, int commandIdx, CatalogApplyResult catalogApplyResult) {
        if (!catalogApplyResult.isApplied(commandIdx)) {
            return CompletableFuture.completedFuture(catalogApplyResult);
        }
        int creationCatalogVersion = catalogApplyResult.getCatalogVersion();
        Catalog catalog = this.catalogManager.catalog(creationCatalogVersion);
        assert (catalog != null) : creationCatalogVersion;
        CatalogSchemaDescriptor schema = catalog.schema(cmd.schemaName());
        assert (schema != null) : "Did not find schema " + cmd.schemaName() + " in version " + creationCatalogVersion;
        CatalogIndexDescriptor index = schema.aliveIndex(cmd.indexName());
        assert (index != null) : "Did not find index " + cmd.indexName() + " in schema " + cmd.schemaName() + " in version " + creationCatalogVersion;
        if (index.status() == CatalogIndexStatus.AVAILABLE) {
            return CompletableFuture.completedFuture(catalogApplyResult);
        }
        CompletableFuture future = this.inFlightFutures.registerFuture(new CompletableFuture());
        EventListener availabilityListener = EventListener.fromConsumer(event -> {
            if (((MakeIndexAvailableEventParameters)event).indexId() == index.id()) {
                this.completeFutureWhenEventVersionActivates((CompletableFuture<Void>)future, (CatalogEventParameters)event);
            }
        });
        this.catalogManager.listen((Event)CatalogEvent.INDEX_AVAILABLE, availabilityListener);
        EventListener removalListener = EventListener.fromConsumer(event -> {
            if (((RemoveIndexEventParameters)event).indexId() == index.id()) {
                future.complete(null);
            }
        });
        this.catalogManager.listen((Event)CatalogEvent.INDEX_REMOVED, removalListener);
        int latestVersion = this.catalogManager.latestCatalogVersion();
        for (int version = creationCatalogVersion + 1; version <= latestVersion; ++version) {
            CatalogIndexDescriptor indexAtVersion = this.catalogManager.catalog(version).index(index.id());
            if (indexAtVersion == null) {
                future.complete(null);
                break;
            }
            if (!indexAtVersion.status().isAvailableOrLater()) continue;
            this.completeFutureWhenEventVersionActivates((CompletableFuture<Void>)future, version);
            break;
        }
        return ((CompletableFuture)future.whenComplete((res, ex) -> {
            this.catalogManager.removeListener((Event)CatalogEvent.INDEX_AVAILABLE, availabilityListener);
            this.catalogManager.removeListener((Event)CatalogEvent.INDEX_REMOVED, removalListener);
        })).thenApply(none -> catalogApplyResult);
    }

    private void completeFutureWhenEventVersionActivates(CompletableFuture<Void> future, CatalogEventParameters event) {
        this.completeFutureWhenEventVersionActivates(future, event.catalogVersion());
    }

    private void completeFutureWhenEventVersionActivates(CompletableFuture<Void> future, int catalogVersion) {
        Catalog catalog = this.catalogManager.catalog(catalogVersion);
        assert (catalog != null);
        HybridTimestamp tsToWait = CatalogUtils.clusterWideEnsuredActivationTimestamp((long)catalog.time(), (long)this.clockService.maxClockSkewMillis());
        this.clockService.waitFor(tsToWait).whenComplete((res, ex) -> future.complete(null));
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() throws Exception {
        this.busyLock.block();
        this.inFlightFutures.failInFlightFutures((Exception)new NodeStoppingException());
    }
}

