/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp;

import java.lang.reflect.Type;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.internal.sql.engine.exec.exp.IgniteSqlFunctions;
import org.apache.ignite.internal.sql.engine.util.IgniteMath;
import org.jetbrains.annotations.Nullable;

public class IgniteExpressions {
    public static Expression makeBinary(ExpressionType binaryType, Expression left, Expression right) {
        switch (binaryType) {
            case Add: {
                return IgniteExpressions.addExact(left, right);
            }
            case Subtract: {
                return IgniteExpressions.subtractExact(left, right);
            }
            case Multiply: {
                return IgniteExpressions.multiplyExact(left, right);
            }
            case Divide: {
                return IgniteExpressions.divideExact(left, right);
            }
        }
        return Expressions.makeBinary((ExpressionType)binaryType, (Expression)left, (Expression)right);
    }

    public static Expression makeDecimalDivision(Expression left, Expression right, int precision, int scale) {
        return Expressions.call(IgniteMath.class, (String)"decimalDivide", (Expression[])new Expression[]{left, right, Expressions.constant((Object)precision, Integer.TYPE), Expressions.constant((Object)scale, Integer.TYPE)});
    }

    public static Expression makeUnary(ExpressionType unaryType, Expression operand) {
        switch (unaryType) {
            case Negate: 
            case NegateChecked: {
                return IgniteExpressions.negateExact(unaryType, operand);
            }
        }
        return Expressions.makeUnary((ExpressionType)unaryType, (Expression)operand);
    }

    public static Expression addExact(Expression left, Expression right) {
        Type largerType = IgniteExpressions.larger(left.getType(), right.getType());
        if (largerType == Integer.TYPE || largerType == Long.TYPE || largerType == Short.TYPE || largerType == Byte.TYPE) {
            return Expressions.call(IgniteMath.class, (String)"addExact", (Expression[])new Expression[]{left, right});
        }
        return Expressions.makeBinary((ExpressionType)ExpressionType.Add, (Expression)left, (Expression)right);
    }

    public static Expression subtractExact(Expression left, Expression right) {
        Type largerType = IgniteExpressions.larger(left.getType(), right.getType());
        if (largerType == Integer.TYPE || largerType == Long.TYPE || largerType == Short.TYPE || largerType == Byte.TYPE) {
            return Expressions.call(IgniteMath.class, (String)"subtractExact", (Expression[])new Expression[]{left, right});
        }
        return Expressions.makeBinary((ExpressionType)ExpressionType.Subtract, (Expression)left, (Expression)right);
    }

    public static Expression multiplyExact(Expression left, Expression right) {
        Type largerType = IgniteExpressions.larger(left.getType(), right.getType());
        if (largerType == Integer.TYPE || largerType == Long.TYPE || largerType == Short.TYPE || largerType == Byte.TYPE) {
            return Expressions.call(IgniteMath.class, (String)"multiplyExact", (Expression[])new Expression[]{left, right});
        }
        return Expressions.makeBinary((ExpressionType)ExpressionType.Multiply, (Expression)left, (Expression)right);
    }

    public static Expression divideExact(Expression left, Expression right) {
        Type largerType = IgniteExpressions.larger(left.getType(), right.getType());
        if (largerType == Integer.TYPE || largerType == Long.TYPE || largerType == Short.TYPE || largerType == Byte.TYPE) {
            return Expressions.call(IgniteMath.class, (String)"divideExact", (Expression[])new Expression[]{left, right});
        }
        return Expressions.makeBinary((ExpressionType)ExpressionType.Divide, (Expression)left, (Expression)right);
    }

    public static Expression addBoundsCheckIfNeeded(SqlTypeName type, Expression expr) {
        String methodName;
        switch (type) {
            case DATE: {
                methodName = "toDateExact";
                break;
            }
            case TIMESTAMP: {
                methodName = "toTimestampExact";
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                methodName = "toTimestampLtzExact";
                break;
            }
            default: {
                return expr;
            }
        }
        return Expressions.call(IgniteSqlFunctions.class, (String)methodName, (Expression[])new Expression[]{expr});
    }

    static Expression convertChecked(Expression exp, Primitive fromPrimitive, Primitive toPrimitive) {
        if (fromPrimitive.ordinal() <= toPrimitive.ordinal() || !toPrimitive.isFixedNumeric()) {
            return Expressions.convert_((Expression)exp, (Type)toPrimitive.primitiveClass);
        }
        return Expressions.call(IgniteMath.class, (String)("convertTo" + SqlFunctions.initcap((String)toPrimitive.primitiveName) + "Exact"), (Expression[])new Expression[]{exp});
    }

    static Expression unboxChecked(Expression exp, @Nullable Primitive fromBox, Primitive toPrimitive) {
        if (fromBox != null && fromBox.ordinal() <= toPrimitive.ordinal() || !toPrimitive.isFixedNumeric()) {
            return Expressions.unbox((Expression)exp, (Primitive)toPrimitive);
        }
        return Expressions.call(IgniteMath.class, (String)("convertTo" + SqlFunctions.initcap((String)toPrimitive.primitiveName) + "Exact"), (Expression[])new Expression[]{exp});
    }

    private static Expression negateExact(ExpressionType unaryType, Expression operand) {
        assert (unaryType == ExpressionType.Negate || unaryType == ExpressionType.NegateChecked);
        Type opType = operand.getType();
        if (opType == Integer.TYPE || opType == Long.TYPE || opType == Short.TYPE || opType == Byte.TYPE) {
            return Expressions.call(IgniteMath.class, (String)"negateExact", (Expression[])new Expression[]{operand});
        }
        return Expressions.makeUnary((ExpressionType)unaryType, (Expression)operand);
    }

    private static Type larger(Type type0, Type type1) {
        if (type0 != Double.TYPE && type0 != Double.class && type1 != Double.TYPE && type1 != Double.class) {
            if (type0 != Float.TYPE && type0 != Float.class && type1 != Float.TYPE && type1 != Float.class) {
                if (type0 != Long.TYPE && type0 != Long.class && type1 != Long.TYPE && type1 != Long.class) {
                    if (type0 != Integer.TYPE && type0 != Integer.class && type1 != Integer.TYPE && type1 != Integer.class) {
                        return type0 != Short.TYPE && type0 != Short.class && type1 != Short.TYPE && type1 != Short.class ? Byte.TYPE : Short.TYPE;
                    }
                    return Integer.TYPE;
                }
                return Long.TYPE;
            }
            return Float.TYPE;
        }
        return Double.TYPE;
    }
}

