/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.rules.LongBitmap;
import org.apache.calcite.rex.RexNode;

public class HyperEdge {
    private final long leftNodeBits;
    private final long rightNodeBits;
    private final JoinRelType joinType;
    private final boolean isSimple;
    private final RexNode condition;

    public HyperEdge(long leftNodeBits, long rightNodeBits, JoinRelType joinType, RexNode condition) {
        this.leftNodeBits = leftNodeBits;
        this.rightNodeBits = rightNodeBits;
        this.joinType = joinType;
        this.condition = condition;
        boolean leftSimple = (leftNodeBits & leftNodeBits - 1L) == 0L;
        boolean rightSimple = (rightNodeBits & rightNodeBits - 1L) == 0L;
        this.isSimple = leftSimple && rightSimple;
    }

    public long getNodeBitmap() {
        return this.leftNodeBits | this.rightNodeBits;
    }

    public long getLeftNodeBitmap() {
        return this.leftNodeBits;
    }

    public long getRightNodeBitmap() {
        return this.rightNodeBits;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public JoinRelType getJoinType() {
        return this.joinType;
    }

    public RexNode getCondition() {
        return this.condition;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LongBitmap.printBitmap(this.leftNodeBits)).append("\u2014\u2014[").append((Object)this.joinType).append(", ").append(this.condition).append("]\u2014\u2014").append(LongBitmap.printBitmap(this.rightNodeBits));
        return sb.toString();
    }
}

