/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.ParameterizedType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public enum ArrayOpCode {
    NOT_PRIMITIVE(null, OpCode.AALOAD, OpCode.AASTORE, null),
    BYTE(Byte.TYPE, OpCode.BALOAD, OpCode.BASTORE, AType.T_BYTE),
    BOOLEAN(Boolean.TYPE, OpCode.BALOAD, OpCode.BASTORE, AType.T_BOOLEAN),
    CHAR(Character.TYPE, OpCode.CALOAD, OpCode.CASTORE, AType.T_CHAR),
    SHORT(Short.TYPE, OpCode.SALOAD, OpCode.SASTORE, AType.T_SHORT),
    INT(Integer.TYPE, OpCode.IALOAD, OpCode.IASTORE, AType.T_INT),
    LONG(Long.TYPE, OpCode.LALOAD, OpCode.LASTORE, AType.T_LONG),
    FLOAT(Float.TYPE, OpCode.FALOAD, OpCode.FASTORE, AType.T_FLOAT),
    DOUBLE(Double.TYPE, OpCode.DALOAD, OpCode.DASTORE, AType.T_DOUBLE);

    private final OpCode load;
    private final OpCode store;
    private final AType atype;
    private final Class<?> type;
    private static final Map<Class<?>, ArrayOpCode> arrayOpCodeMap;

    private ArrayOpCode(Class<?> clazz, @Nullable OpCode load, OpCode store, AType atype) {
        this.type = clazz;
        this.load = Objects.requireNonNull(load, "load is null");
        this.store = Objects.requireNonNull(store, "store is null");
        this.atype = atype;
    }

    public OpCode getLoad() {
        return this.load;
    }

    public OpCode getStore() {
        return this.store;
    }

    public int getAtype() {
        return this.atype.getType();
    }

    public Class<?> getType() {
        return this.type;
    }

    public static ArrayOpCode getArrayOpCode(ParameterizedType type) {
        if (!type.isPrimitive()) {
            return NOT_PRIMITIVE;
        }
        ArrayOpCode arrayOpCode = arrayOpCodeMap.get(type.getPrimitiveType());
        if (arrayOpCode == null) {
            throw new IllegalArgumentException("unsupported primitive type " + String.valueOf(type));
        }
        return arrayOpCode;
    }

    static Map<Class<?>, ArrayOpCode> initializeArrayOpCodeMap() {
        return Arrays.stream(ArrayOpCode.values()).filter(o -> o.getType() != null).collect(Collectors.toMap(ArrayOpCode::getType, Function.identity()));
    }

    static {
        arrayOpCodeMap = ArrayOpCode.initializeArrayOpCodeMap();
    }

    static enum AType {
        T_BOOLEAN(4),
        T_CHAR(5),
        T_FLOAT(6),
        T_DOUBLE(7),
        T_BYTE(8),
        T_SHORT(9),
        T_INT(10),
        T_LONG(11);

        private final int type;

        private AType(int type) {
            this.type = type;
        }

        int getType() {
            return this.type;
        }
    }
}

