/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;

public class PartitionDestructionLockManager {
    private final Map<GroupPartitionId, ReentrantReadWriteLock> lockByPartitionId = new ConcurrentHashMap<GroupPartitionId, ReentrantReadWriteLock>();

    public ReadWriteLock destructionLock(GroupPartitionId groupPartitionId) {
        return this.lockByPartitionId.computeIfAbsent(groupPartitionId, unused -> new ReentrantReadWriteLock());
    }

    public void removeLockForGroup(int groupId) {
        this.lockByPartitionId.entrySet().removeIf(e -> ((GroupPartitionId)e.getKey()).getGroupId() == groupId);
    }
}

