/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MetaPageAddRootRecord
extends PageDeltaRecord {
    private long rootId;

    public MetaPageAddRootRecord(int grpId, long pageId, long rootId) {
        super(grpId, pageId);
        this.rootId = rootId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        BPlusMetaIO io = BPlusMetaIO.VERSIONS.forPage(pageAddr);
        io.addRoot(pageAddr, this.rootId, pageMem.realPageSize(this.groupId()));
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.BTREE_META_PAGE_ADD_ROOT;
    }

    public long rootId() {
        return this.rootId;
    }

    @Override
    public String toString() {
        return S.toString(MetaPageAddRootRecord.class, this, "super", (Object)super.toString());
    }
}

