/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cluster.management.ClusterIdStore;
import org.apache.ignite3.internal.cluster.management.ClusterInitializer;
import org.apache.ignite3.internal.cluster.management.ClusterState;
import org.apache.ignite3.internal.cluster.management.ClusterTag;
import org.apache.ignite3.internal.cluster.management.CmgGroupId;
import org.apache.ignite3.internal.cluster.management.InitException;
import org.apache.ignite3.internal.cluster.management.LocalStateStorage;
import org.apache.ignite3.internal.cluster.management.MetaStorageInfo;
import org.apache.ignite3.internal.cluster.management.NodeAttributes;
import org.apache.ignite3.internal.cluster.management.events.BeforeStartRaftGroupEventParameters;
import org.apache.ignite3.internal.cluster.management.events.ClusterManagerGroupEvent;
import org.apache.ignite3.internal.cluster.management.events.EmptyEventParameters;
import org.apache.ignite3.internal.cluster.management.metrics.ClusterTopologyMetricsSource;
import org.apache.ignite3.internal.cluster.management.metrics.LocalTopologyMetricsSource;
import org.apache.ignite3.internal.cluster.management.network.CmgMessageCallback;
import org.apache.ignite3.internal.cluster.management.network.CmgMessageHandler;
import org.apache.ignite3.internal.cluster.management.network.messages.CancelInitMessage;
import org.apache.ignite3.internal.cluster.management.network.messages.ClusterStateMessage;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgInitMessage;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessageGroup;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgPrepareInitMessage;
import org.apache.ignite3.internal.cluster.management.network.messages.InitErrorMessage;
import org.apache.ignite3.internal.cluster.management.network.messages.RefuseJoinMessage;
import org.apache.ignite3.internal.cluster.management.raft.ClusterStateStorage;
import org.apache.ignite3.internal.cluster.management.raft.ClusterStateStorageManager;
import org.apache.ignite3.internal.cluster.management.raft.CmgRaftGroupListener;
import org.apache.ignite3.internal.cluster.management.raft.CmgRaftService;
import org.apache.ignite3.internal.cluster.management.raft.IllegalInitArgumentException;
import org.apache.ignite3.internal.cluster.management.raft.JoinDeniedException;
import org.apache.ignite3.internal.cluster.management.raft.ValidationManager;
import org.apache.ignite3.internal.cluster.management.topology.LogicalTopology;
import org.apache.ignite3.internal.cluster.management.topology.LogicalTopologyImpl;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.components.SystemPropertiesNodeProperties;
import org.apache.ignite3.internal.disaster.system.message.ResetClusterMessage;
import org.apache.ignite3.internal.disaster.system.storage.ClusterResetStorage;
import org.apache.ignite3.internal.event.AbstractEventProducer;
import org.apache.ignite3.internal.event.EventParameters;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.failure.FailureType;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.network.ClusterNodeImpl;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.network.TopologyEventHandler;
import org.apache.ignite3.internal.network.TopologyService;
import org.apache.ignite3.internal.properties.IgniteProductVersion;
import org.apache.ignite3.internal.raft.Peer;
import org.apache.ignite3.internal.raft.PeersAndLearners;
import org.apache.ignite3.internal.raft.RaftGroupConfiguration;
import org.apache.ignite3.internal.raft.RaftGroupOptionsConfigurer;
import org.apache.ignite3.internal.raft.RaftManager;
import org.apache.ignite3.internal.raft.RaftNodeId;
import org.apache.ignite3.internal.raft.service.RaftGroupService;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.vault.VaultManager;
import org.apache.ignite3.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ClusterManagementGroupManager
extends AbstractEventProducer<ClusterManagerGroupEvent, EventParameters>
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(ClusterManagementGroupManager.class);
    private static final int NETWORK_INVOKE_TIMEOUT_MS = 3000;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    @Nullable
    private volatile CompletableFuture<CmgRaftService> raftService;
    private final Object raftServiceLock = new Object();
    private CompletableFuture<Void> currentUpdateLearners = CompletableFutures.nullCompletedFuture();
    private final Object updateLearnersLock = new Object();
    private final CompletableFuture<Void> joinFuture = new CompletableFuture();
    private final CmgMessagesFactory msgFactory = new CmgMessagesFactory();
    private final ScheduledExecutorService scheduledExecutor;
    private final ClusterService clusterService;
    private final RaftManager raftManager;
    private final ClusterStateStorageManager clusterStateStorageMgr;
    private final LogicalTopology logicalTopology;
    private final ValidationManager validationManager;
    private final LocalStateStorage localStateStorage;
    private final ClusterInitializer clusterInitializer;
    private final NodeAttributes nodeAttributes;
    private final FailureProcessor failureProcessor;
    private final ClusterIdStore clusterIdStore;
    private final ClusterResetStorage clusterResetStorage;
    private final CompletableFuture<String> initialClusterConfigurationFuture = new CompletableFuture();
    private final CmgMessageHandler cmgMessageHandler;
    private final RaftGroupOptionsConfigurer raftGroupOptionsConfigurer;
    private final MetricManager metricsManager;
    private final ClusterTopologyMetricsSource clusterTopologyMetricsSource;
    private final LocalTopologyMetricsSource localTopologyMetricsSource;
    private final NodeProperties nodeProperties;
    private final Consumer<RaftGroupConfiguration> onConfigurationCommittedListener;

    public ClusterManagementGroupManager(VaultManager vault, ClusterResetStorage clusterResetStorage, ClusterService clusterService, ClusterInitializer clusterInitializer, RaftManager raftManager, ClusterStateStorageManager clusterStateStorageMgr, LogicalTopology logicalTopology, ValidationManager validationManager, NodeAttributes nodeAttributes, FailureProcessor failureProcessor, ClusterIdStore clusterIdStore, RaftGroupOptionsConfigurer raftGroupOptionsConfigurer, MetricManager metricManager, NodeProperties nodeProperties) {
        this(vault, clusterResetStorage, clusterService, clusterInitializer, raftManager, clusterStateStorageMgr, logicalTopology, validationManager, nodeAttributes, failureProcessor, clusterIdStore, raftGroupOptionsConfigurer, metricManager, nodeProperties, config -> {});
    }

    public ClusterManagementGroupManager(VaultManager vault, ClusterResetStorage clusterResetStorage, ClusterService clusterService, ClusterInitializer clusterInitializer, RaftManager raftManager, ClusterStateStorageManager clusterStateStorageMgr, LogicalTopology logicalTopology, ValidationManager validationManager, NodeAttributes nodeAttributes, FailureProcessor failureProcessor, ClusterIdStore clusterIdStore, RaftGroupOptionsConfigurer raftGroupOptionsConfigurer, MetricManager metricManager, NodeProperties nodeProperties, Consumer<RaftGroupConfiguration> onConfigurationCommittedListener) {
        this.clusterResetStorage = clusterResetStorage;
        this.clusterService = clusterService;
        this.clusterInitializer = clusterInitializer;
        this.raftManager = raftManager;
        this.clusterStateStorageMgr = clusterStateStorageMgr;
        this.logicalTopology = logicalTopology;
        this.validationManager = validationManager;
        this.localStateStorage = new LocalStateStorage(vault);
        this.nodeAttributes = nodeAttributes;
        this.failureProcessor = failureProcessor;
        this.clusterIdStore = clusterIdStore;
        this.raftGroupOptionsConfigurer = raftGroupOptionsConfigurer;
        this.metricsManager = metricManager;
        this.clusterTopologyMetricsSource = new ClusterTopologyMetricsSource(logicalTopology, () -> {
            LocalStateStorage.LocalState localState = this.localStateStorage.getLocalState();
            if (localState == null) {
                return null;
            }
            return localState.clusterTag();
        });
        this.localTopologyMetricsSource = new LocalTopologyMetricsSource(clusterService.topologyService());
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(IgniteThreadFactory.create(clusterService.nodeName(), "cmg-manager", LOG, new ThreadOperation[0]));
        this.cmgMessageHandler = this.createMessageHandler();
        clusterService.messagingService().addMessageHandler(CmgMessageGroup.class, message -> this.scheduledExecutor, this.cmgMessageHandler);
        this.nodeProperties = nodeProperties;
        this.onConfigurationCommittedListener = onConfigurationCommittedListener;
    }

    private CmgMessageHandler createMessageHandler() {
        CmgMessageCallback messageCallback = new CmgMessageCallback(){

            @Override
            public void onClusterStateMessageReceived(ClusterStateMessage message, InternalClusterNode sender, @Nullable Long correlationId) {
                assert (correlationId != null) : sender;
                ClusterManagementGroupManager.this.handleClusterState(message, sender, correlationId);
            }

            @Override
            public void onCancelInitMessageReceived(CancelInitMessage message, InternalClusterNode sender, @Nullable Long correlationId) {
                ClusterManagementGroupManager.this.handleCancelInit(message);
            }

            @Override
            public void onRefuseJoinMessageReceived(RefuseJoinMessage message, InternalClusterNode sender, @Nullable Long correlationId) {
                ClusterManagementGroupManager.this.handleRefuseJoin(message);
            }

            @Override
            public void onCmgInitMessageReceived(CmgInitMessage message, InternalClusterNode sender, @Nullable Long correlationId) {
                assert (correlationId != null) : sender;
                ClusterManagementGroupManager.this.handleInit(message, sender, correlationId);
            }

            @Override
            public void onCmgPrepareInitMessageReceived(CmgPrepareInitMessage message, InternalClusterNode sender, @Nullable Long correlationId) {
                assert (correlationId != null) : sender;
                ClusterManagementGroupManager.this.handlePrepareInit(message, sender, correlationId);
            }
        };
        return new CmgMessageHandler(this.busyLock, this.msgFactory, this.clusterService, this.failureProcessor, messageCallback);
    }

    @TestOnly
    public ClusterManagementGroupManager(VaultManager vault, ClusterResetStorage clusterResetStorage, ClusterService clusterService, ClusterInitializer clusterInitializer, RaftManager raftManager, ClusterStateStorage clusterStateStorage, LogicalTopology logicalTopology, NodeAttributes nodeAttributes, FailureProcessor failureProcessor, ClusterIdStore clusterIdStore, RaftGroupOptionsConfigurer raftGroupOptionsConfigurer, MetricManager metricManager) {
        this(vault, clusterResetStorage, clusterService, clusterInitializer, raftManager, new ClusterStateStorageManager(clusterStateStorage), logicalTopology, new ValidationManager(new ClusterStateStorageManager(clusterStateStorage), logicalTopology), nodeAttributes, failureProcessor, clusterIdStore, raftGroupOptionsConfigurer, metricManager, new SystemPropertiesNodeProperties());
    }

    @TestOnly
    public ClusterManagementGroupManager(VaultManager vault, ClusterResetStorage clusterResetStorage, ClusterService clusterService, ClusterInitializer clusterInitializer, RaftManager raftManager, ClusterStateStorage clusterStateStorage, LogicalTopology logicalTopology, NodeAttributes nodeAttributes, FailureProcessor failureProcessor, ClusterIdStore clusterIdStore, RaftGroupOptionsConfigurer raftGroupOptionsConfigurer, MetricManager metricManager, NodeProperties nodeProperties, Consumer<RaftGroupConfiguration> onConfigurationCommittedListener) {
        this(vault, clusterResetStorage, clusterService, clusterInitializer, raftManager, new ClusterStateStorageManager(clusterStateStorage), logicalTopology, new ValidationManager(new ClusterStateStorageManager(clusterStateStorage), logicalTopology), nodeAttributes, failureProcessor, clusterIdStore, raftGroupOptionsConfigurer, metricManager, nodeProperties, onConfigurationCommittedListener);
    }

    public void initCluster(Collection<String> metaStorageNodeNames, Collection<String> cmgNodeNames, String clusterName) throws NodeStoppingException {
        ClusterManagementGroupManager.sync(this.initClusterAsync(metaStorageNodeNames, cmgNodeNames, clusterName));
    }

    public void initCluster(Collection<String> metaStorageNodeNames, Collection<String> cmgNodeNames, String clusterName, @Nullable String clusterConfiguration) throws NodeStoppingException {
        ClusterManagementGroupManager.sync(this.initClusterAsync(metaStorageNodeNames, cmgNodeNames, clusterName, clusterConfiguration));
    }

    private static void sync(CompletableFuture<Void> future) {
        try {
            future.join();
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.unwrapCause(e));
        }
    }

    public CompletableFuture<Void> initClusterAsync(Collection<String> metaStorageNodeNames, Collection<String> cmgNodeNames, String clusterName) throws NodeStoppingException {
        return this.initClusterAsync(metaStorageNodeNames, cmgNodeNames, clusterName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> initClusterAsync(Collection<String> metaStorageNodeNames, Collection<String> cmgNodeNames, String clusterName, @Nullable String clusterConfiguration) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            CompletionStage completionStage = this.clusterInitializer.initCluster(metaStorageNodeNames, cmgNodeNames, clusterName, clusterConfiguration).handle((res, e) -> {
                if (e == null) {
                    return res;
                }
                if (e instanceof InterruptedException) {
                    throw new InitException("Interrupted while initializing the cluster", (Throwable)e);
                }
                throw new InitException("Unable to initialize the cluster: " + e.getMessage(), (Throwable)e);
            });
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.metricsManager.registerSource(this.clusterTopologyMetricsSource);
        this.metricsManager.registerSource(this.localTopologyMetricsSource);
        this.metricsManager.enable(this.clusterTopologyMetricsSource);
        this.metricsManager.enable(this.localTopologyMetricsSource);
        ResetClusterMessage resetClusterMessage = this.clusterResetStorage.readResetClusterMessage();
        if (resetClusterMessage != null) {
            return this.doClusterReset(resetClusterMessage);
        }
        Object object = this.raftServiceLock;
        synchronized (object) {
            this.raftService = this.recoverLocalState();
        }
        this.cmgMessageHandler.onRecoveryComplete();
        return CompletableFutures.nullCompletedFuture();
    }

    private CompletableFuture<Void> doClusterReset(ResetClusterMessage resetClusterMessage) {
        LOG.info("Found a ResetClusterMessage in storage, going to do cluster reset [message={}]", resetClusterMessage);
        return ((CompletableFuture)((CompletableFuture)this.destroyCmgWithEvents().thenCompose(unused -> {
            if (resetClusterMessage.newCmgNodes().contains(this.clusterService.nodeName())) {
                return this.doReinit(resetClusterMessage);
            }
            this.cmgMessageHandler.onRecoveryComplete();
            return CompletableFutures.nullCompletedFuture();
        })).thenRun(this.clusterResetStorage::removeResetClusterMessage)).thenRun(() -> this.clusterResetStorage.saveVolatileResetClusterMessage(resetClusterMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<CmgRaftService> doReinit(ResetClusterMessage resetClusterMessage) {
        CompletableFuture<CmgRaftService> serviceFuture;
        Object object = this.raftServiceLock;
        synchronized (object) {
            serviceFuture = this.startCmgRaftServiceWithEvents(resetClusterMessage.newCmgNodes(), null);
            this.raftService = serviceFuture;
        }
        this.cmgMessageHandler.onRecoveryComplete();
        return serviceFuture.thenCompose(service -> this.doInit((CmgRaftService)service, this.cmgInitMessageFromResetClusterMessage(resetClusterMessage), resetClusterMessage.formerClusterIds()));
    }

    private CmgInitMessage cmgInitMessageFromResetClusterMessage(ResetClusterMessage resetClusterMessage) {
        return this.msgFactory.cmgInitMessage().cmgNodes(resetClusterMessage.newCmgNodes()).metaStorageNodes(resetClusterMessage.currentMetaStorageNodes()).clusterName(resetClusterMessage.clusterName()).clusterId(resetClusterMessage.clusterId()).initialClusterConfiguration(resetClusterMessage.initialClusterConfiguration()).build();
    }

    public CompletableFuture<@Nullable ClusterState> clusterState() {
        CompletableFuture<CmgRaftService> serviceFuture = this.raftService;
        return serviceFuture == null ? CompletableFutures.nullCompletedFuture() : serviceFuture.thenCompose(CmgRaftService::readClusterState);
    }

    @Nullable
    private CompletableFuture<CmgRaftService> recoverLocalState() {
        LocalStateStorage.LocalState localState = this.localStateStorage.getLocalState();
        if (localState == null) {
            LOG.info("No local CMG state exists, going to wait for the cluster state or the init command", new Object[0]);
            return null;
        }
        LOG.info("Local CMG state recovered, starting the CMG", new Object[0]);
        return this.startCmgRaftServiceWithEvents(localState.cmgNodeNames(), null).thenCompose(service -> this.validateAgainstCluster((CmgRaftService)service, localState.clusterTag()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInit(CmgInitMessage msg, InternalClusterNode sender, long correlationId) {
        Object object = this.raftServiceLock;
        synchronized (object) {
            CompletionStage<CmgRaftService> serviceFuture = this.raftService;
            if (serviceFuture == null) {
                LOG.info("Init command received, starting the CMG [nodes={}]", msg.cmgNodes());
                serviceFuture = this.startCmgRaftServiceWithEvents(msg.cmgNodes(), msg.initialClusterConfiguration()).whenComplete((v, e) -> this.inBusyLock(() -> {
                    if (e != null) {
                        Throwable finalEx = ExceptionUtils.unwrapCause(e);
                        LOG.error("Unable to start CMG Raft service", finalEx);
                        InitErrorMessage response = this.initErrorMessage(finalEx);
                        this.clusterService.messagingService().respond(sender, (NetworkMessage)response, correlationId);
                    } else {
                        LOG.info("CMG Raft service started successfully.", new Object[0]);
                    }
                }));
            } else {
                LOG.info("Init command received, but the CMG has already been started", new Object[0]);
            }
            this.raftService = ((CompletableFuture)serviceFuture.thenCompose(service -> this.inBusyLockAsync(() -> this.doInit((CmgRaftService)service, msg, null)).handle((v, e) -> this.inBusyLock(() -> {
                NetworkMessage response;
                if (e == null) {
                    LOG.info("CMG initialized successfully", new Object[0]);
                    response = this.msgFactory.initCompleteMessage().build();
                } else {
                    Throwable finalEx = ExceptionUtils.unwrapCause(e);
                    LOG.warn("Error when initializing the CMG", finalEx);
                    response = this.initErrorMessage(finalEx);
                }
                this.clusterService.messagingService().respond(sender, response, correlationId);
                return service;
            })))).whenComplete((cmgRaftService, e) -> {
                if (e != null) {
                    LOG.warn("Error when handling the CMG Init", (Throwable)e);
                }
            });
        }
    }

    private void handlePrepareInit(CmgPrepareInitMessage msg, InternalClusterNode sender, long correlationId) {
        NetworkMessage response;
        LOG.info("CmgPrepareInitMessage message received [sender={}, colocationEnabled={}]", sender.name(), msg.initInitiatorColocationEnabled());
        if (this.nodeProperties.colocationEnabled() != msg.initInitiatorColocationEnabled()) {
            String colocationEnabledMismatchResponseMessage = IgniteStringFormatter.format("Colocation modes do not match [initInitiatorNodeName={}, initInitiatorColocationMode={}, recipientColocationMode={}].", sender.name(), msg.initInitiatorColocationEnabled(), this.nodeProperties.colocationEnabled());
            response = this.preparePhaseInitErrorMessage(colocationEnabledMismatchResponseMessage);
        } else {
            response = this.msgFactory.prepareInitCompleteMessage().build();
        }
        this.clusterService.messagingService().respond(sender, response, correlationId);
    }

    private CompletableFuture<CmgRaftService> doInit(CmgRaftService service, CmgInitMessage msg, @Nullable List<UUID> formerClusterIds) {
        return service.initClusterState(this.createClusterState(msg, formerClusterIds)).thenCompose(state -> {
            LocalStateStorage.LocalState localState = new LocalStateStorage.LocalState(state.cmgNodes(), state.clusterTag());
            this.localStateStorage.saveLocalState(localState);
            return this.validateAgainstCluster(service, state.clusterTag());
        });
    }

    private ClusterState createClusterState(CmgInitMessage msg, @Nullable List<UUID> formerClusterIds) {
        return this.msgFactory.clusterState().cmgNodes(Set.copyOf(msg.cmgNodes())).metaStorageNodes(Set.copyOf(msg.metaStorageNodes())).version(IgniteProductVersion.CURRENT_VERSION.toString()).clusterTag(ClusterTag.clusterTag(this.msgFactory, msg.clusterName(), msg.clusterId())).initialClusterConfiguration(msg.initialClusterConfiguration()).formerClusterIds(formerClusterIds).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onElectedAsLeader(long term, long configurationTerm, long configurationIndex, PeersAndLearners configuration) {
        if (!this.busyLock.enterBusy()) {
            LOG.info("Skipping onLeaderElected callback, because the node is stopping", new Object[0]);
            return;
        }
        try {
            LOG.info("CMG leader has been elected, executing onLeaderElected callback", new Object[0]);
            this.raftServiceAfterJoin().thenAccept(service -> this.inBusyLock(() -> {
                service.readClusterState().thenAccept(state -> this.initialClusterConfigurationFuture.complete(state.initialClusterConfiguration()));
                ((CompletableFuture)((CompletableFuture)this.updateLogicalTopology((CmgRaftService)service).thenCompose(v -> this.inBusyLock(() -> this.updateLearnersSerially((CmgRaftService)service, term, false)))).thenAccept(v -> this.inBusyLock(() -> {
                    TopologyService topologyService = this.clusterService.topologyService();
                    topologyService.addEventHandler(this.cmgLeaderTopologyEventHandler((CmgRaftService)service));
                    InternalClusterNode thisNode = topologyService.localMember();
                    Collection otherNodes = topologyService.allMembers().stream().filter(node -> !thisNode.equals(node)).collect(Collectors.toList());
                    this.sendClusterState((CmgRaftService)service, otherNodes);
                }))).whenComplete((v, e) -> {
                    if (e != null) {
                        if (ExceptionUtils.hasCause(e, NodeStoppingException.class)) {
                            LOG.info("Unable to execute onLeaderElected callback, because the node is stopping", (Throwable)e);
                        } else {
                            this.failureProcessor.process(new FailureContext((Throwable)e, "Error when executing onLeaderElected callback"));
                        }
                    } else {
                        LOG.info("onLeaderElected callback executed successfully", new Object[0]);
                    }
                });
            }));
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private InitErrorMessage initErrorMessage(Throwable finalEx) {
        return this.msgFactory.initErrorMessage().cause(finalEx.getMessage()).shouldCancel(!(finalEx instanceof IllegalInitArgumentException)).build();
    }

    private InitErrorMessage preparePhaseInitErrorMessage(String responseMessage) {
        return this.msgFactory.initErrorMessage().cause(responseMessage).shouldCancel(false).build();
    }

    private CompletableFuture<Void> updateLogicalTopology(CmgRaftService service) {
        return service.logicalTopology().thenCompose(logicalTopology -> this.inBusyLock(() -> {
            Set physicalTopologyIds = this.clusterService.topologyService().allMembers().stream().map(InternalClusterNode::id).collect(Collectors.toSet());
            Set<InternalClusterNode> nodesToRemove = logicalTopology.nodes().stream().filter(node -> !physicalTopologyIds.contains(node.id())).collect(Collectors.toUnmodifiableSet());
            return nodesToRemove.isEmpty() ? CompletableFutures.nullCompletedFuture() : service.removeFromCluster(nodesToRemove);
        }));
    }

    private void handleCancelInit(CancelInitMessage msg) {
        LOG.info("CMG initialization cancelled [reason={}]", msg.reason());
        this.scheduledExecutor.execute(this::destroyCmgWithEvents);
    }

    private void handleRefuseJoin(RefuseJoinMessage msg) {
        LOG.info("Join refused [reason={}]", msg.reason());
        this.joinFuture.completeExceptionally(new InitException(msg.reason()));
    }

    private CompletableFuture<Void> destroyCmgWithEvents() {
        LOG.info("CMG destruction procedure started", new Object[0]);
        return this.inBusyLockAsync(() -> ((CompletableFuture)this.fireEvent(ClusterManagerGroupEvent.BEFORE_DESTROY_RAFT_GROUP, EmptyEventParameters.INSTANCE).thenRunAsync(this::destroyCmg, this.scheduledExecutor)).whenComplete((v, e) -> {
            if (e != null) {
                this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, (Throwable)e));
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyCmg() {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            Object object = this.raftServiceLock;
            synchronized (object) {
                if (this.raftService != null) {
                    this.raftService.cancel(true);
                    this.raftService = null;
                }
                this.raftManager.stopRaftNodes(CmgGroupId.INSTANCE);
                RaftNodeId nodeId = ClusterManagementGroupManager.raftNodeId(new Peer(this.clusterService.nodeName()));
                this.raftManager.destroyRaftNodeStorages(nodeId, this.raftGroupOptionsConfigurer);
                this.localStateStorage.clear();
            }
        }
        catch (NodeStoppingException e) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, "Error when cleaning the CMG state", (Throwable)e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClusterState(ClusterStateMessage msg, InternalClusterNode sender, long correlationId) {
        this.clusterService.messagingService().respond(sender, (NetworkMessage)this.msgFactory.successResponseMessage().build(), correlationId);
        ClusterState state = msg.clusterState();
        this.initialClusterConfigurationFuture.complete(state.initialClusterConfiguration());
        Object object = this.raftServiceLock;
        synchronized (object) {
            if (this.raftService == null) {
                LOG.info("ClusterStateMessage received, starting the CMG [nodes={}]", state.cmgNodes());
                this.raftService = this.initCmgRaftService(state);
            } else {
                this.raftService = ((CompletableFuture)this.raftService.handle((service, e) -> this.inBusyLockAsync(() -> {
                    if (service != null && service.nodeNames().equals(state.cmgNodes())) {
                        LOG.info("ClusterStateMessage received, but the CMG service is already started", new Object[0]);
                        return CompletableFuture.completedFuture(service);
                    }
                    if (service == null) {
                        Throwable finalEx;
                        assert (e != null);
                        Throwable throwable = finalEx = e instanceof CompletionException ? e.getCause() : e;
                        if (finalEx instanceof JoinDeniedException) {
                            return CompletableFuture.failedFuture(finalEx);
                        }
                        LOG.warn("CMG service could not be started on previous attempts. Re-creating the CMG Raft service [reason={}]", finalEx, finalEx.getMessage());
                        return this.initCmgRaftService(state);
                    }
                    LOG.warn("CMG service started, but the cluster state is different. Re-creating the CMG Raft service [localState={}, clusterState={}]", service.nodeNames(), state.cmgNodes());
                    return this.destroyCmgWithEvents().thenCompose(none -> this.initCmgRaftService(state));
                }))).thenCompose(Function.identity());
            }
        }
    }

    private CompletableFuture<CmgRaftService> validateAgainstCluster(CmgRaftService service, ClusterTag clusterTag) {
        return ((CompletableFuture)service.startJoinCluster(clusterTag, this.nodeAttributes).thenApply(v -> service)).whenComplete((v, e) -> {
            if (e == null) {
                LOG.info("Successfully validated against the cluster [name={}]", clusterTag.clusterName());
                this.joinFuture.complete(null);
            } else {
                this.joinFuture.completeExceptionally((Throwable)e);
            }
        });
    }

    private CompletableFuture<CmgRaftService> startCmgRaftServiceWithEvents(Set<String> nodeNames, @Nullable String initialClusterConfig) {
        BeforeStartRaftGroupEventParameters params = new BeforeStartRaftGroupEventParameters(nodeNames, initialClusterConfig);
        return ((CompletableFuture)this.fireEvent(ClusterManagerGroupEvent.BEFORE_START_RAFT_GROUP, params).thenApplyAsync(v -> this.startCmgRaftService(nodeNames), (Executor)this.scheduledExecutor)).whenComplete((v, e) -> {
            if (e != null) {
                LOG.warn("Error when initializing the CMG", (Throwable)e);
            }
        });
    }

    private CmgRaftService startCmgRaftService(Set<String> nodeNames) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            Peer serverPeer;
            String thisNodeConsistentId = this.clusterService.nodeName();
            boolean isLearner = !nodeNames.contains(thisNodeConsistentId);
            Set<String> learnerNames = isLearner ? Set.of(thisNodeConsistentId) : Set.of();
            PeersAndLearners raftConfiguration = PeersAndLearners.fromConsistentIds(nodeNames, learnerNames);
            Peer peer = serverPeer = isLearner ? raftConfiguration.learner(thisNodeConsistentId) : raftConfiguration.peer(thisNodeConsistentId);
            assert (serverPeer != null);
            LOG.info("Starting CMG Raft service [isLearner={}, nodeNames={}, serverPeer={}]", isLearner, nodeNames, serverPeer);
            Object service = this.raftManager.startSystemRaftGroupNodeAndWaitNodeReady(ClusterManagementGroupManager.raftNodeId(serverPeer), raftConfiguration, new CmgRaftGroupListener(this.clusterStateStorageMgr, this.logicalTopology, this.validationManager, this::onLogicalTopologyChanged, this.clusterIdStore, this.failureProcessor, this.onConfigurationCommittedListener), this::onElectedAsLeader, null, this.raftGroupOptionsConfigurer);
            CmgRaftService cmgRaftService = new CmgRaftService((RaftGroupService)service, this.clusterService.topologyService(), this.logicalTopology);
            return cmgRaftService;
        }
        catch (NodeStoppingException e) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private static RaftNodeId raftNodeId(Peer serverPeer) {
        return new RaftNodeId(CmgGroupId.INSTANCE, serverPeer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> updateLearnersSerially(CmgRaftService service, long term, boolean checkLeadership) {
        Object object = this.updateLearnersLock;
        synchronized (object) {
            this.currentUpdateLearners = ((CompletableFuture)this.currentUpdateLearners.thenCompose(v -> {
                if (checkLeadership) {
                    return service.isCurrentNodeLeader().thenCompose(isLeader -> {
                        if (!isLeader.booleanValue()) {
                            return CompletableFutures.nullCompletedFuture();
                        }
                        return service.updateLearners(term);
                    });
                }
                return service.updateLearners(term);
            })).exceptionally(e -> {
                LOG.warn("Failed to update learners for term {}", (Throwable)e, (Object)term);
                return null;
            });
            return this.currentUpdateLearners;
        }
    }

    private void onLogicalTopologyChanged(long term) {
        CompletableFuture<CmgRaftService> serviceFuture = this.raftService;
        if (serviceFuture == null) {
            return;
        }
        serviceFuture.thenCompose(service -> this.updateLearnersSerially((CmgRaftService)service, term, true));
    }

    private CompletableFuture<CmgRaftService> initCmgRaftService(ClusterState state) {
        return this.startCmgRaftServiceWithEvents(state.cmgNodes(), state.initialClusterConfiguration()).thenCompose(service -> this.inBusyLockAsync(() -> {
            LocalStateStorage.LocalState localState = new LocalStateStorage.LocalState(state.cmgNodes(), state.clusterTag());
            this.localStateStorage.saveLocalState(localState);
            return this.validateAgainstCluster((CmgRaftService)service, state.clusterTag());
        }));
    }

    private TopologyEventHandler cmgLeaderTopologyEventHandler(final CmgRaftService raftService) {
        return new TopologyEventHandler(){

            @Override
            public void onAppeared(InternalClusterNode member) {
                raftService.isCurrentNodeLeader().thenAccept(isLeader -> {
                    if (isLeader.booleanValue()) {
                        ClusterManagementGroupManager.this.sendClusterState(raftService, member);
                    }
                });
            }

            @Override
            public void onDisappeared(InternalClusterNode member) {
                raftService.removeFromCluster(Set.of(member));
            }
        };
    }

    private void sendClusterState(CmgRaftService raftService, InternalClusterNode node) {
        this.sendClusterState(raftService, List.of(node));
    }

    private void sendClusterState(CmgRaftService raftService, Collection<InternalClusterNode> nodes) {
        ((CompletableFuture)raftService.logicalTopology().thenCompose(topology -> {
            Set<InternalClusterNode> logicalTopology = topology.nodes().stream().map(node -> new ClusterNodeImpl(node.id(), node.name(), node.address(), node.nodeMetadata())).collect(Collectors.toSet());
            Set<InternalClusterNode> recipients = nodes.stream().filter(node -> !logicalTopology.contains(node)).collect(Collectors.toSet());
            if (recipients.isEmpty()) {
                return CompletableFutures.nullCompletedFuture();
            }
            Set<InternalClusterNode> duplicates = ClusterManagementGroupManager.findDuplicateConsistentIdsOfExistingNodes(logicalTopology, recipients);
            for (InternalClusterNode duplicate : duplicates) {
                RefuseJoinMessage msg = this.msgFactory.refuseJoinMessage().reason("Duplicate node name \"" + duplicate.name() + "\"").build();
                this.sendWithRetry(duplicate, msg);
                recipients.remove(duplicate);
            }
            if (recipients.isEmpty()) {
                return CompletableFutures.nullCompletedFuture();
            }
            return raftService.readClusterState().thenAccept(state -> {
                if (state == null) {
                    throw new IllegalStateException("Cluster state is empty");
                }
                ClusterStateMessage msg = this.msgFactory.clusterStateMessage().clusterState((ClusterState)state).build();
                for (InternalClusterNode node : recipients) {
                    this.sendWithRetry(node, msg);
                }
            });
        })).whenComplete((v, e) -> {
            if (e != null) {
                LOG.error("Unable to send cluster state", (Throwable)e);
            }
        });
    }

    private static Set<InternalClusterNode> findDuplicateConsistentIdsOfExistingNodes(Set<InternalClusterNode> existingTopology, Collection<InternalClusterNode> candidatesForAddition) {
        Set existingConsistentIds = existingTopology.stream().map(InternalClusterNode::name).collect(Collectors.toSet());
        return candidatesForAddition.stream().filter(node -> existingConsistentIds.contains(node.name())).collect(Collectors.toSet());
    }

    private CompletableFuture<Void> sendWithRetry(InternalClusterNode node, NetworkMessage msg) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.sendWithRetry(node, msg, result, 5);
        return result.whenComplete((v, e) -> {
            if (e != null) {
                LOG.warn("Unable to send message [msg={}, target={}]", (Throwable)e, (Object)msg.getClass(), (Object)node);
            }
        });
    }

    private void sendWithRetry(InternalClusterNode node, NetworkMessage msg, CompletableFuture<Void> result, int attempts) {
        this.clusterService.messagingService().invoke(node, msg, 3000L).whenComplete((response, e) -> {
            if (e == null) {
                result.complete(null);
            } else if (attempts == 1) {
                result.completeExceptionally((Throwable)e);
            } else {
                LOG.debug("Unable to send message, going to retry [targetNode={}]", (Throwable)e, (Object)node.name());
                this.scheduledExecutor.schedule(() -> this.sendWithRetry(node, msg, result, attempts - 1), 500L, TimeUnit.MILLISECONDS);
            }
        });
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        CompletableFuture<CmgRaftService> serviceFuture = this.raftService;
        if (serviceFuture != null) {
            IgniteUtils.failOrConsume(serviceFuture, new NodeStoppingException(), CmgRaftService::close);
        }
        IgniteUtils.shutdownAndAwaitTermination(this.scheduledExecutor, 10L, TimeUnit.SECONDS);
        try {
            this.raftManager.stopRaftNodes(CmgGroupId.INSTANCE);
        }
        catch (NodeStoppingException e) {
            return CompletableFuture.failedFuture(e);
        }
        this.joinFuture.completeExceptionally(new NodeStoppingException());
        this.initialClusterConfigurationFuture.completeExceptionally(new NodeStoppingException());
        return this.fireEvent(ClusterManagerGroupEvent.AFTER_STOP_RAFT_GROUP, EmptyEventParameters.INSTANCE);
    }

    public CompletableFuture<Void> joinFuture() {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletableFuture<Void> completableFuture = this.joinFuture;
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<Set<String>> metaStorageNodes() {
        return this.metaStorageInfo().thenApply(MetaStorageInfo::metaStorageNodes);
    }

    public CompletableFuture<MetaStorageInfo> metaStorageInfo() {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.raftServiceAfterJoin().thenCompose(CmgRaftService::readMetaStorageInfo);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<Set<String>> majority() {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.raftServiceAfterJoin().thenCompose(CmgRaftService::majority);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @TestOnly
    public CompletableFuture<Set<String>> learnerNodes() {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.raftServiceAfterJoin().thenCompose(CmgRaftService::learners);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<LogicalTopologySnapshot> logicalTopology() {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.raftServiceAfterJoin().thenCompose(CmgRaftService::logicalTopology);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<Set<InternalClusterNode>> validatedNodes() {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.raftServiceAfterJoin().thenCompose(CmgRaftService::validatedNodes);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<Void> onJoinReady() {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.raftServiceAfterJoin().thenCompose(svc -> svc.completeJoinCluster(this.nodeAttributes));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<Void> changeMetastorageNodes(Set<String> newMetastorageNodes) {
        return this.changeMetastorageNodesInternal(newMetastorageNodes, null);
    }

    public CompletableFuture<Void> changeMetastorageNodes(Set<String> newMetastorageNodes, long metastorageRepairingConfigIndex) {
        return this.changeMetastorageNodesInternal(newMetastorageNodes, metastorageRepairingConfigIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> changeMetastorageNodesInternal(Set<String> newMetastorageNodes, @Nullable Long metastorageRepairingConfigIndex) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.raftServiceAfterJoin().thenCompose(service -> service.changeMetastorageNodes(newMetastorageNodes, metastorageRepairingConfigIndex));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<String> initialClusterConfigurationFuture() {
        return this.initialClusterConfigurationFuture;
    }

    @TestOnly
    CompletableFuture<Boolean> isCmgLeader() {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.raftServiceAfterJoin().thenCompose(CmgRaftService::isCurrentNodeLeader);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CompletableFuture<CmgRaftService> raftServiceAfterJoin() {
        return this.joinFuture.thenCompose(v -> {
            CompletableFuture<CmgRaftService> serviceFuture = this.raftService;
            assert (serviceFuture != null);
            return serviceFuture;
        });
    }

    private void inBusyLock(Runnable action) {
        IgniteUtils.inBusyLock(this.busyLock, action);
    }

    private <T> T inBusyLock(Supplier<T> action) {
        return IgniteUtils.inBusyLock(this.busyLock, action);
    }

    private <T> CompletableFuture<T> inBusyLockAsync(Supplier<CompletableFuture<T>> action) {
        return IgniteUtils.inBusyLockAsync(this.busyLock, action);
    }

    @TestOnly
    LogicalTopologyImpl logicalTopologyImpl() {
        return (LogicalTopologyImpl)this.logicalTopology;
    }
}

