/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.rpc.ActionResponse;
import org.apache.ignite3.raft.jraft.rpc.ActionResponseBuilder;

class ActionResponseDeserializer
implements MessageDeserializer<ActionResponse> {
    private final ActionResponseBuilder msg;

    ActionResponseDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.actionResponse();
    }

    @Override
    public Class<ActionResponse> klass() {
        return ActionResponse.class;
    }

    @Override
    public ActionResponse getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("resultByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.resultByteArray(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ActionResponse.class);
    }
}

