/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.table;

public class DataStreamerOptions {
    public static final DataStreamerOptions DEFAULT = DataStreamerOptions.builder().build();
    private final int pageSize;
    private final int perPartitionParallelOperations;
    private final int autoFlushInterval;
    private final int retryLimit;

    private DataStreamerOptions(int pageSize, int perPartitionParallelOperations, int autoFlushInterval, int retryLimit) {
        this.pageSize = pageSize;
        this.perPartitionParallelOperations = perPartitionParallelOperations;
        this.autoFlushInterval = autoFlushInterval;
        this.retryLimit = retryLimit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int perPartitionParallelOperations() {
        return this.perPartitionParallelOperations;
    }

    public int autoFlushInterval() {
        return this.autoFlushInterval;
    }

    public int retryLimit() {
        return this.retryLimit;
    }

    public static class Builder {
        private int pageSize = 1000;
        private int perPartitionParallelOperations = 1;
        private int autoFlushInterval = 5000;
        private int retryLimit = 16;

        public Builder pageSize(int pageSize) {
            if (pageSize <= 0) {
                throw new IllegalArgumentException("Page size must be positive: " + pageSize);
            }
            this.pageSize = pageSize;
            return this;
        }

        public Builder perPartitionParallelOperations(int perPartitionParallelOperations) {
            if (perPartitionParallelOperations <= 0) {
                throw new IllegalArgumentException("perPartitionParallelOperations must be positive: " + perPartitionParallelOperations);
            }
            this.perPartitionParallelOperations = perPartitionParallelOperations;
            return this;
        }

        public Builder autoFlushInterval(int autoFlushInterval) {
            this.autoFlushInterval = autoFlushInterval;
            return this;
        }

        public Builder retryLimit(int retryLimit) {
            this.retryLimit = retryLimit;
            return this;
        }

        public DataStreamerOptions build() {
            return new DataStreamerOptions(this.pageSize, this.perPartitionParallelOperations, this.autoFlushInterval, this.retryLimit);
        }
    }
}

