/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CommunicationFailureContext;
import org.apache.ignite.configuration.CommunicationFailureResolver;
import org.apache.ignite.internal.cluster.graph.BitSetIterator;
import org.apache.ignite.internal.cluster.graph.ClusterGraph;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultCommunicationFailureResolver
implements CommunicationFailureResolver {
    @LoggerResource
    private IgniteLogger log;

    @Override
    public void resolve(CommunicationFailureContext ctx) {
        ClusterPart largestCluster = this.findLargestConnectedCluster(ctx);
        if (largestCluster == null) {
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Communication problem resolver found fully connected independent cluster [serverNodesCnt=" + largestCluster.srvNodesCnt + ", clientNodesCnt=" + largestCluster.connectedClients.size() + ", totalAliveNodes=" + ctx.topologySnapshot().size() + ", serverNodesIds=" + DefaultCommunicationFailureResolver.clusterNodeIds(largestCluster.srvNodesSet, ctx.topologySnapshot(), 1000) + "]");
        }
        this.keepCluster(ctx, largestCluster);
    }

    @Nullable
    private ClusterPart findLargestConnectedCluster(CommunicationFailureContext ctx) {
        boolean isSplitBrain;
        List srvNodes = ctx.topologySnapshot().stream().filter(node -> !node.isClient()).collect(Collectors.toList());
        ClusterGraph graph = new ClusterGraph(ctx, ClusterNode::isClient);
        List<BitSet> components = graph.findConnectedComponents();
        if (components.isEmpty()) {
            U.warn(this.log, "Unable to find at least one alive server node in the cluster " + ctx);
            return null;
        }
        if (components.size() == 1) {
            BitSet nodesSet = components.get(0);
            int nodeCnt = nodesSet.cardinality();
            boolean fullyConnected = graph.checkFullyConnected(nodesSet);
            if (fullyConnected && nodeCnt == srvNodes.size()) {
                U.warn(this.log, "All alive nodes are fully connected, this should be resolved automatically.");
                return null;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Communication problem resolver detected partial lost for some connections inside cluster. Will keep largest set of healthy fully-connected nodes. Other nodes will be killed forcibly.");
            }
            BitSet fullyConnectedPart = graph.findLargestFullyConnectedComponent(nodesSet);
            Set<ClusterNode> connectedClients = this.findConnectedClients(ctx, fullyConnectedPart);
            return new ClusterPart(fullyConnectedPart, connectedClients);
        }
        boolean bl = isSplitBrain = components.size() > 1 && components.stream().filter(cmp -> cmp.size() > 1).count() > 1L;
        if (isSplitBrain) {
            U.warn(this.log, "Communication problem resolver detected split brain. Cluster has splitted on " + components.size() + " independent parts. Will keep only one largest fully-connected part. Other nodes will be killed forcibly.");
        } else {
            U.warn(this.log, "Communication problem resolver detected full lost for some connections inside cluster. Problem nodes will be found and killed forcibly.");
        }
        ClusterPart largestCluster = null;
        for (int i = 0; i < components.size(); ++i) {
            BitSet clusterPart = components.get(i);
            BitSet fullyConnectedPart = graph.findLargestFullyConnectedComponent(clusterPart);
            Set<ClusterNode> connectedClients = this.findConnectedClients(ctx, fullyConnectedPart);
            ClusterPart curr = new ClusterPart(fullyConnectedPart, connectedClients);
            if (largestCluster != null && curr.compareTo(largestCluster) <= 0) continue;
            largestCluster = curr;
        }
        assert (largestCluster != null) : "Unable to find at least one alive independent cluster.";
        return largestCluster;
    }

    private void keepCluster(CommunicationFailureContext ctx, ClusterPart clusterPart) {
        ClusterNode node;
        int idx;
        List<ClusterNode> allNodes = ctx.topologySnapshot();
        for (idx = 0; idx < allNodes.size(); ++idx) {
            node = allNodes.get(idx);
            if (node.isClient() || clusterPart.srvNodesSet.get(idx)) continue;
            ctx.killNode(node);
        }
        for (idx = 0; idx < allNodes.size(); ++idx) {
            node = allNodes.get(idx);
            if (!node.isClient() || clusterPart.connectedClients.contains(node)) continue;
            ctx.killNode(node);
        }
    }

    private Set<ClusterNode> findConnectedClients(CommunicationFailureContext ctx, BitSet srvNodesSet) {
        HashSet<ClusterNode> connectedClients = new HashSet<ClusterNode>();
        List<ClusterNode> allNodes = ctx.topologySnapshot();
        for (ClusterNode node : allNodes) {
            if (!node.isClient()) continue;
            boolean hasConnections = true;
            BitSetIterator it = new BitSetIterator(srvNodesSet);
            while (it.hasNext()) {
                int srvNodeIdx = (Integer)it.next();
                ClusterNode srvNode = allNodes.get(srvNodeIdx);
                if (ctx.connectionAvailable(node, srvNode) && ctx.connectionAvailable(srvNode, node)) continue;
                hasConnections = false;
                break;
            }
            if (!hasConnections) continue;
            connectedClients.add(node);
        }
        return connectedClients;
    }

    private static String clusterNodeIds(BitSet cluster, List<ClusterNode> nodes, int limit) {
        int idx;
        int startIdx = 0;
        StringBuilder builder = new StringBuilder();
        int cnt = 0;
        while ((idx = cluster.nextSetBit(startIdx)) != -1) {
            startIdx = idx + 1;
            if (builder.length() == 0) {
                builder.append('[');
            } else {
                builder.append(", ");
            }
            builder.append(nodes.get(idx).id());
            if (cnt++ <= limit) continue;
            builder.append(", ...");
        }
        builder.append(']');
        return builder.toString();
    }

    public String toString() {
        return S.toString(DefaultCommunicationFailureResolver.class, this);
    }

    private static class ClusterPart
    implements Comparable<ClusterPart> {
        int srvNodesCnt;
        BitSet srvNodesSet;
        Set<ClusterNode> connectedClients;

        public ClusterPart(BitSet srvNodesSet, Set<ClusterNode> connectedClients) {
            this.srvNodesSet = srvNodesSet;
            this.srvNodesCnt = srvNodesSet.cardinality();
            this.connectedClients = connectedClients;
        }

        @Override
        public int compareTo(@NotNull ClusterPart o) {
            int srvNodesCmp = Integer.compare(this.srvNodesCnt, o.srvNodesCnt);
            if (srvNodesCmp != 0) {
                return srvNodesCmp;
            }
            return Integer.compare(this.connectedClients.size(), o.connectedClients.size());
        }
    }
}

