/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mem.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.ignite.internal.mem.DirectMemoryRegion;
import org.apache.ignite.internal.mem.UnsafeChunk;
import org.apache.ignite.internal.util.typedef.internal.U;
import sun.nio.ch.FileChannelImpl;

public class MappedFile
implements Closeable,
DirectMemoryRegion {
    private static final Method map0 = U.findNonPublicMethod(FileChannelImpl.class, "map0", Integer.TYPE, Long.TYPE, Long.TYPE);
    private static final Method unmap0 = U.findNonPublicMethod(FileChannelImpl.class, "unmap0", Long.TYPE, Long.TYPE);
    public static final int MAP_RW = 1;
    private final RandomAccessFile file;
    private final long addr;
    private final long size;

    public MappedFile(File name, long size) throws IOException {
        this.file = new RandomAccessFile(name, "rw");
        try {
            if (size == 0L) {
                size = this.file.length();
            } else {
                this.file.setLength(size);
            }
            this.addr = MappedFile.map(this.file, 1, 0L, size);
            this.size = size;
        }
        catch (IOException e) {
            this.file.close();
            throw e;
        }
    }

    public final RandomAccessFile file() {
        return this.file;
    }

    @Override
    public void close() throws IOException {
        try {
            MappedFile.unmap(this.addr, this.size);
        }
        finally {
            this.file.close();
        }
    }

    @Override
    public final long address() {
        return this.addr;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public DirectMemoryRegion slice(long offset) {
        if (offset < 0L || offset >= this.size) {
            throw new IllegalArgumentException("Failed to create a memory region slice [ptr=" + U.hexLong(this.addr) + ", len=" + this.size + ", offset=" + offset + ']');
        }
        return new UnsafeChunk(this.addr + offset, this.size - offset);
    }

    public static long map(RandomAccessFile f, int mode, long start, long size) throws IOException {
        try {
            return (Long)map0.invoke((Object)f.getChannel(), mode, start, size);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            throw target instanceof IOException ? (IOException)target : new IOException(target);
        }
    }

    public static void unmap(long addr, long size) {
        try {
            unmap0.invoke(null, addr, size);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
    }
}

