/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class NewRootInitRecord<L>
extends PageDeltaRecord {
    private long newRootId;
    private BPlusInnerIO<L> io;
    private long leftChildId;
    private byte[] rowBytes;
    private long rightChildId;

    public NewRootInitRecord(int grpId, long pageId, long newRootId, BPlusInnerIO<L> io, long leftChildId, byte[] rowBytes, long rightChildId) {
        super(grpId, pageId);
        assert (io != null);
        this.newRootId = newRootId;
        this.io = io;
        this.leftChildId = leftChildId;
        this.rowBytes = rowBytes;
        this.rightChildId = rightChildId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        this.io.initNewRoot(pageAddr, this.newRootId, this.leftChildId, null, this.rowBytes, this.rightChildId, pageMem.realPageSize(this.groupId()), false);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.BTREE_INIT_NEW_ROOT;
    }

    public BPlusInnerIO<L> io() {
        return this.io;
    }

    public long rootId() {
        return this.newRootId;
    }

    public long leftId() {
        return this.leftChildId;
    }

    public long rightId() {
        return this.rightChildId;
    }

    public byte[] rowBytes() {
        return this.rowBytes;
    }

    @Override
    public String toString() {
        return S.toString(NewRootInitRecord.class, this, "super", (Object)super.toString());
    }
}

