/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicateAdapter;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class CacheEntryPredicateContainsValue
extends CacheEntryPredicateAdapter {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private CacheObject val;

    public CacheEntryPredicateContainsValue() {
    }

    public CacheEntryPredicateContainsValue(CacheObject val) {
        assert (val != null);
        this.val = val;
    }

    @Override
    public boolean apply(GridCacheEntryEx e) {
        CacheObject val = this.peekVisibleValue(e);
        if (this.val == null && val == null) {
            return true;
        }
        if (this.val == null || val == null) {
            return false;
        }
        GridCacheContext cctx = e.context();
        if (this.val instanceof BinaryObject && val instanceof BinaryObject) {
            return F.eq(val, this.val);
        }
        Object thisVal = CU.value(this.val, cctx, false);
        Object cacheVal = CU.value(val, cctx, false);
        return F.eq(thisVal, cacheVal);
    }

    @Override
    public void finishUnmarshal(GridCacheContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        this.val.finishUnmarshal(ctx.cacheObjectContext(), ldr);
    }

    @Override
    public void prepareMarshal(GridCacheContext ctx) throws IgniteCheckedException {
        this.val.prepareMarshal(ctx.cacheObjectContext());
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeMessage("val", this.val)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.val = (CacheObject)reader.readMessage("val");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CacheEntryPredicateContainsValue.class);
    }

    @Override
    public short directType() {
        return 98;
    }

    @Override
    public byte fieldsCount() {
        return 1;
    }

    public String toString() {
        return S.toString(CacheEntryPredicateContainsValue.class, this);
    }
}

