/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc.msg;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.IgniteCodeGeneratingFail;
import org.apache.ignite.internal.processors.cache.mvcc.MvccLongList;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotWithoutTxs;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccMessage;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

@IgniteCodeGeneratingFail
public class MvccSnapshotResponse
implements MvccMessage,
MvccSnapshot,
MvccLongList {
    private static final long serialVersionUID = 0L;
    private long futId;
    private long crdVer;
    private long cntr;
    private int opCntr;
    @GridDirectTransient
    @GridToStringExclude
    private int txsCnt;
    @GridToStringInclude
    private long[] txs;
    private long cleanupVer;
    @GridDirectTransient
    private long tracking;

    public void init(long futId, long crdVer, long cntr, int opCntr, long cleanupVer, long tracking) {
        this.futId = futId;
        this.crdVer = crdVer;
        this.cntr = cntr;
        this.opCntr = opCntr;
        this.cleanupVer = cleanupVer;
        this.tracking = tracking;
        if (this.txsCnt > 0 && this.txs.length > this.txsCnt) {
            this.txs = Arrays.copyOf(this.txs, this.txsCnt);
        }
    }

    public void addTx(long txId) {
        if (this.txs == null) {
            this.txs = new long[4];
        } else if (this.txs.length == this.txsCnt) {
            this.txs = Arrays.copyOf(this.txs, this.txs.length << 1);
        }
        this.txs[this.txsCnt++] = txId;
    }

    @Override
    public int size() {
        return this.txsCnt;
    }

    @Override
    public long get(int i) {
        return this.txs[i];
    }

    @Override
    public boolean contains(long val) {
        for (int i = 0; i < this.txsCnt; ++i) {
            if (this.txs[i] != val) continue;
            return true;
        }
        return false;
    }

    public long tracking() {
        return this.tracking;
    }

    @Override
    public boolean waitForCoordinatorInit() {
        return false;
    }

    @Override
    public boolean processedFromNioThread() {
        return false;
    }

    public long futureId() {
        return this.futId;
    }

    @Override
    public long cleanupVersion() {
        return this.cleanupVer;
    }

    @Override
    public long counter() {
        return this.cntr;
    }

    @Override
    public int operationCounter() {
        return this.opCntr;
    }

    @Override
    public void incrementOperationCounter() {
        ++this.opCntr;
    }

    @Override
    public MvccLongList activeTransactions() {
        return this;
    }

    @Override
    public MvccSnapshot withoutActiveTransactions() {
        if (this.txsCnt > 0) {
            return new MvccSnapshotWithoutTxs(this.crdVer, this.cntr, this.opCntr, this.cleanupVer);
        }
        return this;
    }

    @Override
    public long coordinatorVersion() {
        return this.crdVer;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeLong("cleanupVer", this.cleanupVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("cntr", this.cntr)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLong("crdVer", this.crdVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeInt("opCntr", this.opCntr)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeLongArray("txs", this.txs)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.cleanupVer = reader.readLong("cleanupVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.cntr = reader.readLong("cntr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.crdVer = reader.readLong("crdVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.opCntr = reader.readInt("opCntr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.txs = reader.readLongArray("txs");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.txsCnt = this.txs != null ? this.txs.length : 0;
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(MvccSnapshotResponse.class);
    }

    @Override
    public short directType() {
        return 141;
    }

    @Override
    public byte fieldsCount() {
        return 6;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(MvccSnapshotResponse.class, this);
    }
}

