/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.processors.cache.persistence.PageStoreWriter;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.DelayedPageReplacementTracker;
import org.apache.ignite.internal.util.GridUnsafe;
import org.jetbrains.annotations.Nullable;

public class DelayedDirtyPageStoreWrite
implements PageStoreWriter {
    private final PageStoreWriter flushDirtyPage;
    private final int pageSize;
    private final ThreadLocal<ByteBuffer> byteBufThreadLoc;
    private final DelayedPageReplacementTracker tracker;
    @Nullable
    private FullPageId fullPageId;
    @Nullable
    private ByteBuffer byteBuf;
    private int tag = -1;

    public DelayedDirtyPageStoreWrite(PageStoreWriter flushDirtyPage, ThreadLocal<ByteBuffer> byteBufThreadLoc, int pageSize, DelayedPageReplacementTracker tracker) {
        this.flushDirtyPage = flushDirtyPage;
        this.pageSize = pageSize;
        this.byteBufThreadLoc = byteBufThreadLoc;
        this.tracker = tracker;
    }

    @Override
    public void writePage(FullPageId fullPageId, ByteBuffer byteBuf, int tag) {
        this.tracker.lock(fullPageId);
        ByteBuffer tlb = this.byteBufThreadLoc.get();
        tlb.rewind();
        long writeAddr = GridUnsafe.bufferAddress(tlb);
        long origBufAddr = GridUnsafe.bufferAddress(byteBuf);
        GridUnsafe.copyMemory(origBufAddr, writeAddr, this.pageSize);
        this.fullPageId = fullPageId;
        this.byteBuf = tlb;
        this.tag = tag;
    }

    public void finishReplacement() throws IgniteCheckedException {
        if (this.byteBuf == null && this.fullPageId == null) {
            return;
        }
        try {
            this.flushDirtyPage.writePage(this.fullPageId, this.byteBuf, this.tag);
        }
        finally {
            this.tracker.unlock(this.fullPageId);
            this.fullPageId = null;
            this.byteBuf = null;
            this.tag = -1;
        }
    }
}

