/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.cache.query.QueryMetrics;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridCacheQueryMetricsAdapter
implements QueryMetrics {
    private final AtomicLongMetric minTime;
    private final AtomicLongMetric maxTime;
    private final LongAdderMetric sumTime;
    private final LongAdderMetric execs;
    private final LongAdderMetric completed;
    private final LongAdderMetric fails;

    public GridCacheQueryMetricsAdapter(GridMetricManager mmgr, String cacheName, boolean isNear) {
        MetricRegistry mreg = mmgr.registry(MetricUtils.cacheMetricsRegistryName(cacheName, isNear));
        this.minTime = mreg.longMetric("QueryMinimalTime", null);
        this.minTime.value(Long.MAX_VALUE);
        this.maxTime = mreg.longMetric("QueryMaximumTime", null);
        this.sumTime = mreg.longAdderMetric("QuerySumTime", null);
        this.execs = mreg.longAdderMetric("QueryExecuted", null);
        this.completed = mreg.longAdderMetric("QueryCompleted", null);
        this.fails = mreg.longAdderMetric("QueryFailed", null);
    }

    @Override
    public long minimumTime() {
        long min = this.minTime.value();
        return min == Long.MAX_VALUE ? 0L : min;
    }

    @Override
    public long maximumTime() {
        return this.maxTime.value();
    }

    @Override
    public double averageTime() {
        double val = this.completed.value();
        return val > 0.0 ? (double)this.sumTime.value() / val : 0.0;
    }

    @Override
    public int executions() {
        return (int)this.execs.value();
    }

    @Override
    public int fails() {
        return (int)this.fails.value();
    }

    public void update(long duration, boolean fail) {
        if (fail) {
            this.execs.increment();
            this.fails.increment();
        } else {
            this.execs.increment();
            this.completed.increment();
            MetricUtils.setIfLess(this.minTime, duration);
            MetricUtils.setIfGreater(this.maxTime, duration);
            this.sumTime.add(duration);
        }
    }

    public QueryMetrics snapshot() {
        long minTimeVal = this.minTime.value();
        return new QueryMetricsSnapshot(minTimeVal == Long.MAX_VALUE ? 0L : minTimeVal, this.maxTime.value(), this.averageTime(), (int)this.execs.value(), (int)this.fails.value());
    }

    public void reset() {
        this.minTime.value(Long.MAX_VALUE);
        this.maxTime.reset();
        this.sumTime.reset();
        this.execs.reset();
        this.completed.reset();
        this.fails.reset();
    }

    public String toString() {
        return S.toString(GridCacheQueryMetricsAdapter.class, this);
    }

    public static class QueryMetricsSnapshot
    implements QueryMetrics,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private long minTime;
        private long maxTime;
        private double avgTime;
        private int execs;
        private int fails;

        public QueryMetricsSnapshot() {
        }

        public QueryMetricsSnapshot(long minTime, long maxTime, double avgTime, int execs, int fails) {
            this.minTime = minTime;
            this.maxTime = maxTime;
            this.avgTime = avgTime;
            this.execs = execs;
            this.fails = fails;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.minTime);
            out.writeLong(this.maxTime);
            out.writeDouble(this.avgTime);
            out.writeInt(this.execs);
            out.writeInt(this.fails);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.minTime = in.readLong();
            this.maxTime = in.readLong();
            this.avgTime = in.readDouble();
            this.execs = in.readInt();
            this.fails = in.readInt();
        }

        @Override
        public long minimumTime() {
            return this.minTime;
        }

        @Override
        public long maximumTime() {
            return this.maxTime;
        }

        @Override
        public double averageTime() {
            return this.avgTime;
        }

        @Override
        public int executions() {
            return this.execs;
        }

        @Override
        public int fails() {
            return this.fails;
        }
    }
}

