/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.datastructures;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicLongImpl;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;

public class PlatformAtomicLong
extends PlatformAbstractTarget {
    private final GridCacheAtomicLongImpl atomicLong;
    private static final int OP_ADD_AND_GET = 1;
    private static final int OP_CLOSE = 2;
    private static final int OP_COMPARE_AND_SET = 3;
    private static final int OP_COMPARE_AND_SET_AND_GET = 4;
    private static final int OP_DECREMENT_AND_GET = 5;
    private static final int OP_GET = 6;
    private static final int OP_GET_AND_ADD = 7;
    private static final int OP_GET_AND_DECREMENT = 8;
    private static final int OP_GET_AND_INCREMENT = 9;
    private static final int OP_GET_AND_SET = 10;
    private static final int OP_INCREMENT_AND_GET = 11;
    private static final int OP_IS_CLOSED = 12;

    public PlatformAtomicLong(PlatformContext ctx, GridCacheAtomicLongImpl atomicLong) {
        super(ctx);
        assert (atomicLong != null);
        this.atomicLong = atomicLong;
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 3: {
                long cmp = reader.readLong();
                long val = reader.readLong();
                return this.atomicLong.compareAndSet(cmp, val) ? 1L : 0L;
            }
            case 4: {
                long expVal = reader.readLong();
                long newVal = reader.readLong();
                return this.atomicLong.compareAndSetAndGet(expVal, newVal);
            }
        }
        return super.processInStreamOutLong(type, reader);
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 1: {
                return this.atomicLong.addAndGet(val);
            }
            case 7: {
                return this.atomicLong.getAndAdd(val);
            }
            case 10: {
                return this.atomicLong.getAndSet(val);
            }
            case 2: {
                this.atomicLong.close();
                return 1L;
            }
            case 5: {
                return this.atomicLong.decrementAndGet();
            }
            case 6: {
                return this.atomicLong.get();
            }
            case 8: {
                return this.atomicLong.getAndDecrement();
            }
            case 9: {
                return this.atomicLong.getAndIncrement();
            }
            case 11: {
                return this.atomicLong.incrementAndGet();
            }
            case 12: {
                return this.atomicLong.removed() ? 1L : 0L;
            }
        }
        return super.processInLongOutLong(type, val);
    }
}

