/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.schema;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.typedef.internal.S;

public class SchemaOperationException
extends IgniteCheckedException {
    private static final long serialVersionUID = 0L;
    public static final int CODE_GENERIC = 0;
    public static final int CODE_CACHE_NOT_FOUND = 1;
    public static final int CODE_TABLE_NOT_FOUND = 2;
    public static final int CODE_TABLE_EXISTS = 3;
    public static final int CODE_COLUMN_NOT_FOUND = 4;
    public static final int CODE_COLUMN_EXISTS = 5;
    public static final int CODE_INDEX_NOT_FOUND = 6;
    public static final int CODE_INDEX_EXISTS = 7;
    public static final int CODE_CACHE_ALREADY_INDEXED = 8;
    private final int code;

    public SchemaOperationException(int code, String objName) {
        super(SchemaOperationException.message(code, objName));
        this.code = code;
    }

    public SchemaOperationException(String msg) {
        this(msg, null);
    }

    public SchemaOperationException(String msg, Throwable cause) {
        super(msg, cause);
        this.code = 0;
    }

    public int code() {
        return this.code;
    }

    @Override
    public String toString() {
        return S.toString(SchemaOperationException.class, this, "msg", (Object)this.getMessage());
    }

    private static String message(int code, String objName) {
        switch (code) {
            case 1: {
                return "Cache doesn't exist: " + objName;
            }
            case 2: {
                return "Table doesn't exist: " + objName;
            }
            case 3: {
                return "Table already exists: " + objName;
            }
            case 4: {
                return "Column doesn't exist: " + objName;
            }
            case 5: {
                return "Column already exists: " + objName;
            }
            case 6: {
                return "Index doesn't exist: " + objName;
            }
            case 7: {
                return "Index already exists: " + objName;
            }
            case 8: {
                return "Cache is already indexed: " + objName;
            }
        }
        assert (false);
        return null;
    }
}

