/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.performancestatistics;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.performancestatistics.handlers.PrintHandler;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.performancestatistics.FilePerformanceStatisticsReader;
import org.apache.ignite.internal.processors.performancestatistics.OperationType;
import org.apache.ignite.internal.processors.performancestatistics.PerformanceStatisticsHandler;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class PerformanceStatisticsPrinter {
    public static void main(String ... args) throws Exception {
        Parameters params = PerformanceStatisticsPrinter.parseArguments(args);
        PerformanceStatisticsPrinter.validateParameters(params);
        PrintStream ps = PerformanceStatisticsPrinter.printStream(params.outFile);
        try {
            new FilePerformanceStatisticsReader(new PerformanceStatisticsHandler[]{new PrintHandler(ps, params.ops, params.from, params.to, params.cacheIds)}).read(Collections.singletonList(new File(params.statFileOrDir)));
        }
        finally {
            if (params.outFile != null) {
                ps.close();
            }
        }
    }

    private static Parameters parseArguments(String[] args) {
        if (args == null || args.length == 0 || "--help".equalsIgnoreCase(args[0]) || "-h".equalsIgnoreCase(args[0])) {
            PerformanceStatisticsPrinter.printHelp();
        }
        Parameters params = new Parameters();
        Iterator<String> iter = Arrays.asList(args).iterator();
        params.statFileOrDir = iter.next();
        while (iter.hasNext()) {
            String arg = iter.next();
            if ("--out".equalsIgnoreCase(arg)) {
                A.ensure((boolean)iter.hasNext(), (String)"Expected output file name");
                params.outFile = iter.next();
                continue;
            }
            if ("--ops".equalsIgnoreCase(arg)) {
                A.ensure((boolean)iter.hasNext(), (String)"Expected operation types");
                String[] ops = iter.next().split(",");
                A.ensure((ops.length > 0 ? 1 : 0) != 0, (String)"Expected at least one operation");
                params.ops = new BitSet();
                for (String op : ops) {
                    OperationType opType = PerformanceStatisticsPrinter.enumIgnoreCase(op, OperationType.class);
                    A.ensure((opType != null ? 1 : 0) != 0, (String)("Unknown operation type [op=" + op + ']'));
                    params.ops.set(opType.id());
                }
                continue;
            }
            if ("--from".equalsIgnoreCase(arg)) {
                A.ensure((boolean)iter.hasNext(), (String)"Expected time from");
                params.from = Long.parseLong(iter.next());
                continue;
            }
            if ("--to".equalsIgnoreCase(arg)) {
                A.ensure((boolean)iter.hasNext(), (String)"Expected time to");
                params.to = Long.parseLong(iter.next());
                continue;
            }
            if ("--caches".equalsIgnoreCase(arg)) {
                A.ensure((boolean)iter.hasNext(), (String)"Expected cache names");
                String[] caches = iter.next().split(",");
                A.ensure((caches.length > 0 ? 1 : 0) != 0, (String)"Expected at least one cache name");
                params.cacheIds = Arrays.stream(caches).map(GridCacheUtils::cacheId).collect(Collectors.toSet());
                continue;
            }
            throw new IllegalArgumentException("Unknown command: " + arg);
        }
        return params;
    }

    private static void printHelp() {
        String ops = Arrays.stream(OperationType.values()).map(Enum::toString).collect(Collectors.joining(", "));
        System.out.println("The script is used to print performance statistics files to the console or file." + U.nl() + U.nl() + "Usage: print-statistics.sh path_to_files [--out out_file] [--ops op_types] [--from startTimeFrom] [--to startTimeTo] [--caches cache_names]" + U.nl() + U.nl() + "  path_to_files - Performance statistics file or files directory." + U.nl() + "  out_file      - Output file." + U.nl() + "  op_types      - Comma separated list of operation types to filter the output." + U.nl() + "  from          - The minimum operation start time to filter the output." + U.nl() + "  to            - The maximum operation start time to filter the output." + U.nl() + "  cache_names   - Comma separated list of cache names to filter the output." + U.nl() + U.nl() + "Times must be specified in the Unix time format in milliseconds." + U.nl() + "List of operation types: " + ops + '.');
        System.exit(0);
    }

    private static void validateParameters(Parameters params) {
        File statFileOrDir = new File(params.statFileOrDir);
        A.ensure((boolean)statFileOrDir.exists(), (String)"Performance statistics file or files directory does not exists");
    }

    private static PrintStream printStream(@Nullable String outFile) {
        PrintStream ps;
        if (outFile != null) {
            try {
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(outFile), true)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot write to output file", e);
            }
        } else {
            ps = System.out;
        }
        return ps;
    }

    @Nullable
    private static <E extends Enum<E>> E enumIgnoreCase(String name, Class<E> cls) {
        for (Enum e : (Enum[])cls.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(name)) continue;
            return (E)e;
        }
        return null;
    }

    private static class Parameters {
        private String statFileOrDir;
        @Nullable
        private String outFile;
        @Nullable
        private BitSet ops;
        private long from = Long.MIN_VALUE;
        private long to = Long.MAX_VALUE;
        @Nullable
        private Set<Integer> cacheIds;

        private Parameters() {
        }
    }
}

