/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.drools.compiler.integrationtests.concurrency;

import java.util.stream.Stream;

import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil2;
import org.junit.jupiter.api.condition.EnabledIfSystemProperty;

@EnabledIfSystemProperty(named = "runTurtleTests", matches = "true")
public class AccumulateFunctionConcurrencyTest extends BaseConcurrencyTest {

    public static Stream<KieBaseTestConfiguration> parameters() {
        return TestParametersUtil2.getKieBaseCloudConfigurations(false).stream(); // fails with exec-model. file JIRA
    }

    protected String getDrl() {
        return "package com.example.reproducer\n" +
                "import " + Bus.class.getCanonicalName() + ";\n" +
                "import static " + StaticUtils.class.getCanonicalName() + ".TOSTRING;\n" +
                "dialect \"mvel\"\n" +
                "global java.util.List result;\n" +
                "rule \"rule_mt_1a\"\n" +
                "    when\n" +
                "        accumulate($bus : Bus( $title: \"POWER PLANT\" ), " +
                "                   $min : min(TOSTRING($bus.karaoke.dvd[$title].artist).length()) )\n" +
                "    then\n" +
                "end";
    }
}
