<!--
   Licensed to the Apache Software Foundation (ASF) under one
   or more contributor license agreements.  See the NOTICE file
   distributed with this work for additional information
   regarding copyright ownership.  The ASF licenses this file
   to you under the Apache License, Version 2.0 (the
   "License"); you may not use this file except in compliance
   with the License.  You may obtain a copy of the License at
     http://www.apache.org/licenses/LICENSE-2.0
   Unless required by applicable law or agreed to in writing,
   software distributed under the License is distributed on an
   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
   KIND, either express or implied.  See the License for the
   specific language governing permissions and limitations
   under the License.
-->

# 10.1.0

- Changed default SVG generation settings to improve compatibility with the `src/main/resources/META-INF/processSVG` directory. When there's no customized configuration for SVG generation, SVG files are now placed in the same directory as the open file if not inside a `src/main/resources` structure, or on `src/main/resources/META-INF/processSVG/**/` if it is. The directory structure after `src/main/resources` is kept inside the `processSVG` dir. The same is true for DMN models, but the SVG directory is `META-INF/decisionSVG`.
- New Form generation command `> BPMN Editor: Generate form code for User Tasks` lets you generate code for User Tasks of BPMN models. You can select specific User Tasks and choose from the Bootstrap 4 and PatternFly UI libraries. The generated code is place inside the `src/main/resources/custom-forms-dev` directory.

# 10.0.0

-

# 0.32.0 (alpha)

- NO-ISSUE - Improved localization for Stunner BPMN Editor

# 0.31.0 (alpha)

- _(No new features)_

# 0.30.0 (alpha)

- _(No new features)_

# 0.29.0 (alpha)

- _(No new features)_

# 0.28.1 (alpha)

- [KOGITO-9105](https://issues.redhat.com/browse/KOGITO-9105) - Add KIE prefix to `displayName` of new VS Code extensions

# 0.28.0 (alpha)

- [kie-issues#102](https://github.com/apache/incubator-kie-issues/issues/102) - BPMN Editor: Zooming in/out does not update the toolbox for correct size by @inodeman in https://github.com/apache/incubator-kie-tools/pull/1470
- [kie-issues#139](https://github.com/apache/incubator-kie-issues/issues/139) - BPMN Editor breaking if `bpmn2` file lacks `id` by @pefernan in https://github.com/apache/incubator-kie-tools/pull/1523
- [kie-issues#117](https://github.com/apache/incubator-kie-issues/issues/117) - BPMN Editor: Enable auto population of DMN fields in Business Rule Task by @inodeman in https://github.com/apache/incubator-kie-tools/pull/1524
- [KOGITO-8946](https://issues.redhat.com/browse/KOGITO-8946) - Missing structureref type for service task in VSCode BPMN editor by @hasys in https://github.com/apache/incubator-kie-tools/pull/1542

# 0.26.0 (alpha)

- [kie-issues#6](https://github.com/apache/incubator-kie-issues/issues/6) - Bump `gwt` version to `2.10.0` version in `stunner-editors` module
- [KOGITO-6974](https://issues.redhat.com/browse/KOGITO-6974) - Stunner Editors - Line control points are enabled in view only mode, but they should not

# 0.25.0 (alpha)

- [KOGITO-8077](https://issues.redhat.com/browse/KOGITO-8077) - Apache KIE Tools Security updates (3rd round)

# 0.24.0 (alpha)

- _(No new features)_

# 0.23.0 (alpha)

- _(No new features)_

# 0.22.0 (alpha)

- _(No new features)_

# 0.21.0 (alpha)

- _(No new features)_

# 0.20.0 (alpha)

- _(No new features)_

# 0.19.0 (alpha)

- [KOGITO-6210](https://issues.redhat.com/browse/KOGITO-6210) - BPMN editor loses data assignment

# 0.18.0 (alpha)

- [KOGITO-5735](https://issues.redhat.com/browse/KOGITO-5735) - Stunner - Provide an initial JS / TS API to interact with nodes and connectors
- [KOGITO-6830](https://issues.redhat.com/browse/KOGITO-6830) - Remove `kie-soup-bom`dependency from the `stunner-editors` package
- [KOGITO-6832](https://issues.redhat.com/browse/KOGITO-6832) - Stunner - Update Tooltip message for Priority property in Task
- [KOGITO-6841](https://issues.redhat.com/browse/KOGITO-6841) - Remove `kie-parent` from the `stunner-editors` package

# 0.17.0 (alpha)

- [KOGITO-4686](https://issues.redhat.com/browse/KOGITO-4686) - Cannot open DMN/BPMN files from command line with VS Code
- [KOGITO-6496](https://issues.redhat.com/browse/KOGITO-6496) - Remove unused/unnecessary dependencies with KIE V7 from `stunner-editors`
- [KOGITO-6181](https://issues.redhat.com/browse/KOGITO-6181) - Stunner-based editors are losing focus when asked for the SVG

# 0.16.0 (alpha)

- _(No new features)_

# 0.15.0 (alpha)

- [KOGITO-6036](https://issues.redhat.com/browse/KOGITO-6036) - Use html `<input type='color'>` picker

# 0.14.1 (alpha)

- [KOGITO-6226](https://issues.redhat.com/browse/KOGITO-6226) - Editor content sanitization

# 0.14.0 (alpha)

- [KOGITO-2099](https://issues.redhat.com/browse/KOGITO-2099) - Generate a SVG diagram automatically on each BPMN/DMN diagrams save
- [KOGITO-5973](https://issues.redhat.com/browse/KOGITO-5973) - Stunner - Create an initial JS / TS API for accessing the canvas and its elements
- [KOGITO-2133](https://issues.redhat.com/browse/KOGITO-2133) - [VSCode] Custom editor save issues
- [KOGITO-2553](https://issues.redhat.com/browse/KOGITO-2553) - Editors - Editing the node name and pressing enter to confirm

# 0.13.0 (alpha)

- [KOGITO-5678](https://issues.redhat.com/browse/KOGITO-5678) - Metadata atrribute 'elementname' not present for events, intermediate events & gateways by default
- [KOGITO-5676](https://issues.redhat.com/browse/KOGITO-5676) - BPMN Editor - Containment not working when Node overlaps the Connector while splicing
- [KOGITO-5725](https://issues.redhat.com/browse/KOGITO-5725) - Enable extensions for github.dev.

# 0.12.0 (alpha)

- [KOGITO-2313](https://issues.redhat.com/browse/KOGITO-4136) - BPMN Editor - Support for node/events metadata attributes
- [KOGITO-3164](https://issues.redhat.com/browse/KOGITO-3164) - Stunner - Task Resize option doesn't show up
- [KOGITO-5091](https://issues.redhat.com/browse/KOGITO-5091) - VSCode DMN, BPMN editor - creating connection can't be cancelled easily
- [KOGITO-5241](https://issues.redhat.com/browse/KOGITO-5241) - Stunner - Resize Icon remains displayed
- [KOGITO-5470](https://issues.redhat.com/browse/KOGITO-5470) - BPMN Editor - Cannot import some processes
- [KOGITO-5506](https://issues.redhat.com/browse/KOGITO-5506) - BPMN Editor - Marshallers encoding issues
- [KOGITO-5576](https://issues.redhat.com/browse/KOGITO-5576) - BPMN Editor - Moving connector's bendpoints results on erros in the console
- [KOGITO-5594](https://issues.redhat.com/browse/KOGITO-5594) - [Stunner] bend point modification causes diagram inaccessible
- [KOGITO-5274](https://issues.redhat.com/browse/KOGITO-5274) - Stunner - Line splicing
- [KOGITO-4827](https://issues.redhat.com/browse/KOGITO-4827) - Implement E2E automation for Reuse of Data Types in BPMN Designer
- [KOGITO-5382](https://issues.redhat.com/browse/KOGITO-5382) - Verify support for node/event metadata attribues feature
- [KOGITO-5422](https://issues.redhat.com/browse/KOGITO-5422) - Stunner - first POC of new marshallers
- [KOGITO-5496](https://issues.redhat.com/browse/KOGITO-5496) - Update vscode-extension-tester to 4.1.0
- [KOGITO-5648](https://issues.redhat.com/browse/KOGITO-5648) - [DMN/BPMN] Wired web apps - Fix doc screenshot
- [KOGITO-4413](https://issues.redhat.com/browse/KOGITO-4413) - Implement - designs for orthogonal lines between diagram nodes
- [KOGITO-4765](https://issues.redhat.com/browse/KOGITO-4765) - [Test Scenario] - Errors when executing models using imported inputs and/or decisions nodes
- [KOGITO-4978](https://issues.redhat.com/browse/KOGITO-4978) - Stunner - Make new nodes editable automatically
- [KOGITO-4979](https://issues.redhat.com/browse/KOGITO-4979) - Stunner - Resize control points - Fixes & UX improvements
- [KOGITO-5208](https://issues.redhat.com/browse/KOGITO-5208) - [Stunner] Lienzo - Migration to native interfaces
- [KOGITO-5242](https://issues.redhat.com/browse/KOGITO-5242) - Stunner - Alignment helpers missing during node resize
- [KOGITO-5549](https://issues.redhat.com/browse/KOGITO-5549) - Stunner - WID files with comments and Imports can't be loaded

# 0.11.0 (alpha)

### New features:

- [KOGITO-5132](https://issues.redhat.com/browse/KOGITO-5132) - BPMN Editor - Improve SVG generated ids
- [KOGITO-5142](https://issues.redhat.com/browse/KOGITO-5142) - [DMN/BPMN] Sync kogito-editors-java with latest translations
- [KOGITO-5378](https://issues.redhat.com/browse/KOGITO-5378) - Kogito Tooling VS Code extensions Workspaces Trust
- [KOGITO-4671](https://issues.redhat.com/browse/KOGITO-4671) - New elements should always be connected by their central magnetic point
- [KOGITO-4980](https://issues.redhat.com/browse/KOGITO-4980) - Stunner - Palette fixes & improvements

### Fixed issues:

- [KOGITO-3998](https://issues.redhat.com/browse/KOGITO-3998) - It's not possible to save arrow edits
- [KOGITO-4935](https://issues.redhat.com/browse/KOGITO-4935) - [BC included] [DMN/BPMN editor] Sometimes clicking outside doesn't unselect nodes
- [KOGITO-4977](https://issues.redhat.com/browse/KOGITO-4977) - Stunner - Texts overlap toolboxes
- [KOGITO-5011](https://issues.redhat.com/browse/KOGITO-5011) - Stunner - Unknown Custom tasks in Designer makes Diagram Explorer empty
- [KOGITO-5168](https://issues.redhat.com/browse/KOGITO-5168) - Stunner - Editing text using Inline editor is shown over Properties panel or Expanded Palette
- [KOGITO-5169](https://issues.redhat.com/browse/KOGITO-5169) - Stunner - The order of Custom tasks in the palette is different with every process opening

# 0.10.0 (alpha)

### New features:

--

### Fixed issues:

--

# 0.9.1 (alpha)

## New features:

Infrastructure

- [KOGITO-4914](https://issues.redhat.com/browse/KOGITO-4914) - The SVG icon is broken on vscode-insiders

Editors

- [KOGITO-2528](https://issues.redhat.com/browse/KOGITO-2528) - [BPMN] Reuse Data Types across the process

## Fixed issues:

Editors

- [KOGITO-4892](https://issues.redhat.com/browse/KOGITO-4892) - Unable to view service tasks in VS Code on Windows

# 0.9.0 (alpha)

## New features:

Infrastructure

- [KOGITO-4349](https://issues.redhat.com/browse/KOGITO-4349) - Publish VS Code Extensions to OpenVSX registry

Editors

- [KOGITO-540](https://issues.redhat.com/browse/KOGITO-540) - BPMN Editor - Read Only mode
- [KOGITO-3525](https://issues.redhat.com/browse/KOGITO-3525) - Enhance compatibility of BPMN VS Code Extensions with V7

## Fixed issues:

Infrastructure

--

Editors

--

# 0.8.6 (alpha)

--

# 0.8.5 (alpha)

## New features:

Infrastructure

- [KOGITO-4666](https://issues.redhat.com/browse/KOGITO-4666) - Converge the CSS to avoid conflicts between PF3 and PF4

Editors

--

## Fixed issues:

Infrastructure

--

Editors

--

# 0.8.4 (alpha)

--

# 0.8.3 (alpha)

### Fixed issues:

Editors

- [[KOGITO-4315](https://issues.redhat.com/browse/KOGITO-4315)] - Stunner - Cannot undo/redo more than once

# 0.8.2 (alpha)

### New features:

#### Editors

- [[KOGITO-3853](https://issues.redhat.com/browse/KOGITO-3853)] - [DMN editor] Move the "structure" option to top of the Data Type drop-down
- [[KOGITO-3885](https://issues.redhat.com/browse/KOGITO-3885)] - [DMN editor] Show parameters list for Decision Services

### Fixed issues:

#### Editors

- [[KOGITO-4104](https://issues.redhat.com/browse/KOGITO-4104)] - [DMN editor] Rename "Dismiss" to "Skip tour"
- [[KOGITO-1429](https://issues.redhat.com/browse/KOGITO-1429)] - DefaultXmlFormatter: Should return plain text if formatting fails
- [[KOGITO-1677](https://issues.redhat.com/browse/KOGITO-1677)] - [DMN editor] User cannot open DMN editor if it was previously saved in workspace
- [[KOGITO-2187](https://issues.redhat.com/browse/KOGITO-2187)] - DMN editor when moving DS output decision becomes encapsulated
- [[KOGITO-2515](https://issues.redhat.com/browse/KOGITO-2515)] - DMN Editor decision service wrong layout
- [[KOGITO-2712](https://issues.redhat.com/browse/KOGITO-2712)] - [DMN editor] VS Code Included models self reference
- [[KOGITO-3151](https://issues.redhat.com/browse/KOGITO-3151)] - [DMN editor] Copied value is pasted twice
- [[KOGITO-3476](https://issues.redhat.com/browse/KOGITO-3476)] - DMN decision table "Unable to resolve type reference 'UNDEFINED'" in simple data types
- [[KOGITO-4124](https://issues.redhat.com/browse/KOGITO-4124)] - Error when adding constraints to a data type
- [[KOGITO-4165](https://issues.redhat.com/browse/KOGITO-4165)] - [DMN editor] 'continue' vs 'Continue'

# 0.8.1 (alpha)

## Fixed issues

VS Code

- [[KOGITO-2629](https://issues.redhat.com/browse/KOGITO-2629)] - [VSCode] Undo/redo command don't fire for webviews if used from command palette
- [[KOGITO-3808](https://issues.redhat.com/browse/KOGITO-3808)] - Fix Keyboard Shortcuts modal title on VS Code dark theme
- [[KOGITO-3884](https://issues.redhat.com/browse/KOGITO-3884)] - Save SVG file using the kieserver naming convention
- [[KOGITO-3901](https://issues.redhat.com/browse/KOGITO-3901)] - Cannot Include DMNs on VS Code- Kogito Bundle on Windows
- [[KOGITO-3348](https://issues.redhat.com/browse/KOGITO-3348)] - Fix Open SVG popup to not open SVG when clicking the X button

# 0.8.0 (alpha)

No changes.

# 0.7.1 (alpha)

## New features

Editors

- [[KOGITO-1886](https://issues.redhat.com/browse/KOGITO-1886)] - [BPMN] Reuse Data Types across the process

# 0.7.0 (alpha)

## New features

VS Code

- [[KOGITO-1508](https://issues.redhat.com/browse/KOGITO-1508)] - Implement selenium test for kogito-bpmn in community
- [[KOGITO-1517](https://issues.redhat.com/browse/KOGITO-1517)] - Improve accessibility on file with unsupported extension error
- [[KOGITO-2210](https://issues.redhat.com/browse/KOGITO-2210)] - Define Integration API for Java Backend Services
- [[KOGITO-2863](https://issues.redhat.com/browse/KOGITO-2863)] - Think about removing a default Envelope from `embedded-editor`
- [[KOGITO-2887](https://issues.redhat.com/browse/KOGITO-2887)] - Implement a sample service
- [[KOGITO-3042](https://issues.redhat.com/browse/KOGITO-3042)] - Replace MessageBusClient with proxified version of ApiToConsume
- [[KOGITO-3043](https://issues.redhat.com/browse/KOGITO-3043)] - Provide locale information in a way that GWT can read
- [[KOGITO-3056](https://issues.redhat.com/browse/KOGITO-3056)] - Move I18nService and and its Envelope/Channel APIs to its own module
- [[KOGITO-3057](https://issues.redhat.com/browse/KOGITO-3057)] - Add a initialLocale prop on I18nDictionariesProvider
- [[KOGITO-3096](https://issues.redhat.com/browse/KOGITO-3096)] - CI for kogito-tooling-java
- [[KOGITO-3100](https://issues.redhat.com/browse/KOGITO-3100)] - Documentation for backend services
- [[KOGITO-2984](https://issues.redhat.com/browse/KOGITO-2984)] - Use i18n dictionaries on VS Code extension backend
- [[KOGITO-3205](https://issues.redhat.com/browse/KOGITO-3205)] - Create test runner service running on the backend infra

## Fixed issues

VS Code

- [[KOGITO-3313](https://issues.redhat.com/browse/KOGITO-3313)] - Fix on filename change
- [[KOGITO-3326](https://issues.redhat.com/browse/KOGITO-3326)] - Enable EmbeddedEditor to support an update on the StateControl instance
- [[KOGITO-3417](https://issues.redhat.com/browse/KOGITO-3417)] - EditorEnvelopeView reference should be get with a function to be updated
- [[KOGITO-3314](https://issues.redhat.com/browse/KOGITO-3314)] - Broken link on popup due to circular dependency issue

# 0.6.1 (alpha)

## New features

VS Code

- [KOGITO-3089](https://issues.redhat.com/browse/KOGITO-3089) - Add button on VS Code to generate SVG for BPMN and DMN editors

Editors

- [KOGITO-2644](https://issues.redhat.com/browse/KOGITO-2644) - Add auto start property for adhoc subprocess

## Fixed issues

VS Code

- [KOGITO-2579](https://issues.redhat.com/browse/KOGITO-2579) - Custom Editor VS Code issues on 1.46 version (probably fixed on 1.47)
- [KOGITO-1689](https://issues.redhat.com/browse/KOGITO-1689) - Save when multiple assets opened
- [KOGITO-2134](https://issues.redhat.com/browse/KOGITO-2134) - [VSCode] Allow custom editors to hook into Edit menu actions
- [KOGITO-2135](https://issues.redhat.com/browse/KOGITO-2135) - [VSCode] Custom editor does not open properly
- [KOGITO-1980](https://issues.redhat.com/browse/KOGITO-1980) - Update labels from `VSCode` to `VS Code`

Editors

- [KOGITO-2953](https://issues.redhat.com/browse/KOGITO-2953) - Fix Guided Tour styles

# 0.6.0 (alpha)

## New features

VS Code

- [KOGITO-2076](https://issues.redhat.com/browse/KOGITO-2076) Open File API
- [KOGITO-2180](https://issues.redhat.com/browse/KOGITO-2180) Use KeyboardShortcutsAPI with StateControlAPI (Undo/Redo)
- [KOGITO-2542](https://issues.redhat.com/browse/KOGITO-2542) Update Hub to install VS Code extension from Marketplace
- [KOGITO-766](https://issues.redhat.com/browse/KOGITO-766) Keyboard Shortcuts API
- [KOGITO-1373](https://issues.redhat.com/browse/KOGITO-1373) Integrate the new StateControl API (Undo/Redo/Is Dirty) on the different channels
- [KOGITO-2132](https://issues.redhat.com/browse/KOGITO-2132) Adapt to new VS Code 1.46

## Fixed issues

VS Code

- [KOGITO-745](https://issues.redhat.com/browse/KOGITO-745) Command Y to undo isn't mapped
- [KOGITO-2490](https://issues.redhat.com/browse/KOGITO-2490) Shortcuts should not be triggered when typing on text inputs
- [KOGITO-2493](https://issues.redhat.com/browse/KOGITO-2493) Update and use @types/vscode
- [KOGITO-2580](https://issues.redhat.com/browse/KOGITO-2580) Add noImplicitAny property back into tsconfig.json
- [KOGITO-2581](https://issues.redhat.com/browse/KOGITO-2581) Delete isDirty method on core-api

Editors

- [KOGITO-1196](https://issues.redhat.com/browse/KOGITO-1196) Editor goes back horizontally when diagram is bigger than default
- [KOGITO-1661](https://issues.redhat.com/browse/KOGITO-1661) BPMN Examples have 'null' in process type property
- [KOGITO-1997](https://issues.redhat.com/browse/KOGITO-1997) Stunner - Process metadata attribute value should be a free string
- [KOGITO-2166](https://issues.redhat.com/browse/KOGITO-2166) VS Code editor - Package property: default is not a valid Java package name
