import { v4 as uuid } from "uuid";
import { XmlParserTsIdRandomizer } from "@kie-tools/xml-parser-ts/dist/idRandomizer";
import { elements as dmn15elements, meta as dmn15meta } from "../schemas/dmn-1_5/ts-gen/meta";
import { buildXmlHref, parseXmlHref } from "../xml/xmlHrefs";
export function getNewDmnIdRandomizer() {
    return new XmlParserTsIdRandomizer({
        meta: dmn15meta,
        elements: dmn15elements,
        newIdGenerator: () => `_${uuid()}`.toLocaleUpperCase(),
        matchers: [tDmnElementReferenceIdRandomizerMatcher],
    });
}
export const tDmnElementReferenceIdRandomizerMatcher = ({ parentJson, metaTypeName, attr, }) => {
    if (metaTypeName === "DMN15__tDMNElementReference" && attr === "@_href") {
        const href = parseXmlHref(parentJson[attr]);
        return [
            href.id,
            ({ newId }) => {
                console.debug(`ID RANDOMIZER: [anyURI] Updating id from ${href.id} to ${newId} @ (${String(metaTypeName)}.${String(attr)}: ${parentJson[attr]})`);
                parentJson[attr] = buildXmlHref({ ...href, id: newId });
            },
        ];
    }
};
//# sourceMappingURL=dmnIdRandomizer.js.map