import { ns as dmn10ns } from "../dmn-1_0/ts-gen/meta";
import { ns as dmn11ns } from "../dmn-1_1/ts-gen/meta";
import { ns as dmn12ns } from "../dmn-1_2/ts-gen/meta";
import { ns as dmn13ns } from "../dmn-1_3/ts-gen/meta";
import { ns as dmn14ns } from "../dmn-1_4/ts-gen/meta";
import { ns as dmn15ns } from "./ts-gen/meta";
const feelNameStart = /^[?A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u10000-\uEFFFF].*$/;
const feelNamePart = /^.[?A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u10000-\uEFFFF\u00B7\d\u0300-\u036F\u203F-\u2040.+-/*’\s^]*$/;
const forbiddenEndingChars = /^.*[.:+-/*\s^]$/;
export const DMN15_SPEC = {
    namedElement: {
        isValidName: (id, name, allUniqueNames) => {
            return (!!(name === null || name === void 0 ? void 0 : name.trim()) &&
                !!name.match(feelNameStart) &&
                !!name.match(feelNamePart) &&
                !(name === null || name === void 0 ? void 0 : name.trim().match(forbiddenEndingChars)) &&
                (!allUniqueNames.get(name === null || name === void 0 ? void 0 : name.trim()) || allUniqueNames.get(name === null || name === void 0 ? void 0 : name.trim()) === id));
        },
    },
    expressionLanguage: { default: `https://www.omg.org/spec/DMN/20230324/FEEL/` },
    typeLanguage: { default: `https://www.omg.org/spec/DMN/20230324/FEEL/` },
    IMPORT: {
        name: {
            isValid: (id, name, allUniqueNames) => {
                return name === "" || DMN15_SPEC.namedElement.isValidName(id, name, allUniqueNames);
            },
        },
    },
    BOXED: {
        DECISION_TABLE: {
            PreferredOrientation: { default: "Rule-as-Row" },
            HitPolicy: { default: "UNIQUE" },
        },
        FUNCTION: {
            kind: { default: "FEEL" },
            JAVA: {
                classFieldName: "class",
                methodSignatureFieldName: "method signature",
            },
            PMML: {
                documentFieldName: "document",
                modelFieldName: "model",
            },
        },
    },
    ITEM_DEFINITIONS: {
        isCollection: { default: "false" },
    },
    ANNOTATIONS: {
        format: { default: "text/plain" },
    },
    ASSOCIATIONS: {
        direction: { default: "None" },
    },
    SHAPE: {
        isCollapsed: {
            default: "false",
        },
    },
};
export const allDmnImportNamespaces = new Set([
    dmn10ns.get(""),
    dmn11ns.get(""),
    dmn12ns.get(""),
    dmn13ns.get(""),
    dmn14ns.get(""),
    dmn15ns.get(""),
]);
export const KIE_DMN_UNKNOWN_NAMESPACE = "https://kie.apache.org/dmn/unknown";
//# sourceMappingURL=Dmn15Spec.js.map