import { jsx as _jsx } from "react/jsx-runtime";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
import { HelpIcon } from "@patternfly/react-icons/dist/js/icons/help-icon";
import { filterDOMProps } from "uniforms";
filterDOMProps.register("decimal", "minCount", "autoValue", "isDisabled", "exclusiveMaximum", "exclusiveMinimum", "menuAppendTo");
export default function wrapField({ id, label, type, disabled, error, errorMessage, showInlineError, help, required, description, ...props }, children) {
    return (_jsx(FormGroup, { "data-testid": "wrapper-field", fieldId: id, label: label, labelIcon: description ? (_jsx(Popover, { bodyContent: description, children: _jsx("button", { type: "button", "aria-label": "field description", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { noVerticalAlign: true }) }) })) : undefined, isRequired: required, validated: error ? "error" : "default", type: type, helperText: help, helperTextInvalid: errorMessage, ...filterDOMProps(props), children: children }));
}
//# sourceMappingURL=wrapField.js.map