import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useCallback, useEffect, useImperativeHandle, useState } from "react";
import { v4 as uuidv4 } from "uuid";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Grid, GridItem } from "@patternfly/react-core/dist/js/layouts/Grid";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import PlusCircleIcon from "@patternfly/react-icons/dist/esm/icons/plus-circle-icon";
import TrashIcon from "@patternfly/react-icons/dist/esm/icons/trash-icon";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const CloudEventCustomHeadersEditor = React.forwardRef(({ ouiaId, ouiaSafe }, forwardedRef) => {
    const [headers, setHeaders] = useState([]);
    const [isNewHeader, setIsNewHeader] = useState(false);
    useEffect(() => {
        setIsNewHeader(false);
    }, [isNewHeader]);
    useImperativeHandle(forwardedRef, () => {
        return {
            reset() {
                setHeaders([]);
                setIsNewHeader(false);
            },
            getCustomHeaders() {
                const result = {};
                headers
                    .filter((entry) => entry.key && entry.value)
                    .forEach((entry) => {
                    result[entry.key] = entry.value;
                });
                return result;
            },
        };
    }, [headers]);
    const addNewHeader = useCallback(() => {
        const headersCopy = [...headers];
        headersCopy.push({
            uuid: uuidv4(),
            key: "",
            value: "",
        });
        setHeaders(headersCopy);
        setIsNewHeader(true);
    }, [headers]);
    const deleteHeader = useCallback((index) => {
        const headersCopy = [...headers];
        headersCopy.splice(index, 1);
        setHeaders(headersCopy);
    }, [headers]);
    const updateHeaderKey = useCallback((index, value) => {
        const headersCopy = [...headers];
        headersCopy[index].key = value;
        setHeaders(headersCopy);
    }, [headers]);
    const updateHeaderValue = useCallback((index, value) => {
        const headersCopy = [...headers];
        headersCopy[index].value = value;
        setHeaders(headersCopy);
    }, [headers]);
    return (_jsx("div", { ...componentOuiaProps(ouiaId, "custom-headers-editor", ouiaSafe), children: _jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsx(Button, { variant: "link", isInline: true, icon: _jsx(PlusCircleIcon, {}), onClick: () => addNewHeader(), children: "Add Header" }, "add-header-button") }), headers.length > 0 && (_jsx(StackItem, { children: _jsxs(Grid, { ...componentOuiaProps((ouiaId ? ouiaId : "custom-headers-editor") + "-grid", "custom-headers-editor", true), children: [_jsx(GridItem, { span: 4, children: _jsx("h4", { children: "Header Name" }) }, "headers-grid-col-header"), _jsx(GridItem, { span: 8, children: _jsx("h4", { children: "Value" }) }, "headers-grid-col-value"), headers.map((header, index) => {
                                return (_jsxs(React.Fragment, { children: [_jsx(GridItem, { span: 4, children: _jsx(TextInput, { id: `header-key-${index}-input`, value: header.key, onChange: (value) => updateHeaderKey(index, value), autoFocus: isNewHeader && index === headers.length - 1 }) }, `header-key-${header.uuid}`), _jsx(GridItem, { span: 7, children: _jsx(TextInput, { id: `header-value-${index}-input`, value: header.value, onChange: (value) => updateHeaderValue(index, value) }) }, `header-value-${header.uuid}`), _jsx(GridItem, { span: 1, children: _jsx(Button, { variant: "plain", "aria-label": "delete", onClick: () => deleteHeader(index), children: _jsx(TrashIcon, {}) }, `header-delete-${index}-button`) }, `header-delete-${header.uuid}`)] }, `headers-grid-row-${header.uuid}`));
                            })] }) }))] }) }));
});
export default CloudEventCustomHeadersEditor;
//# sourceMappingURL=CloudEventCustomHeadersEditor.js.map