import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Card, CardBody, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { Dropdown, DropdownToggle, DropdownItem } from "@patternfly/react-core/dist/js/components/Dropdown";
import { TextContent, Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { useState, useEffect } from "react";
import { CaretDownIcon } from "@patternfly/react-icons/dist/js/icons/caret-down-icon";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import WorkflowDetailsErrorModal from "../WorkflowDetailsErrorModal/WorkflowDetailsErrorModal";
import "../styles.css";
const WorkflowDetailsNodeTrigger = ({ workflowInstanceData, driver, ouiaId, ouiaSafe, }) => {
    const [isOpen, setIsOpen] = useState(false);
    const [selectedNode, setSelectedNode] = useState();
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [modalTitle, setModalTitle] = useState("");
    const [titleType, setTitleType] = useState("");
    const [modalContent, setModalContent] = useState("");
    const [isError, setIsError] = useState(false);
    const [nodes, setNodes] = useState([]);
    useEffect(() => {
        (async () => {
            await driver
                .getTriggerableNodes(workflowInstanceData)
                .then((nodeInstances) => {
                setIsError(false);
                setNodes(nodeInstances);
            })
                .catch((error) => {
                setIsError(true);
                setModalTitle("Node trigger Error");
                setModalContent(`Retrieval of nodes failed with error: ${error.message}`);
                setTitleType("failure");
                handleModalToggle();
            });
        })();
    }, []);
    const handleModalToggle = () => {
        setIsModalOpen(!isModalOpen);
    };
    const onSelect = (event) => {
        setIsOpen(!isOpen);
        getSelectedNode(event.currentTarget.id);
    };
    const onToggle = (isDropDownOpen) => {
        setIsOpen(isDropDownOpen);
    };
    const getSelectedNode = (selectedNodeName) => {
        if (nodes.length > 0) {
            const selectedNodeObject = nodes.filter((node) => node.id === selectedNodeName);
            setSelectedNode(selectedNodeObject[0]);
        }
    };
    const createNodeDropDown = () => {
        const nodeDropDown = [];
        nodes.length > 0 &&
            nodes.forEach((node) => {
                node.type !== null &&
                    node.type !== "StartNode" &&
                    node.type !== "Join" &&
                    nodeDropDown.push(_jsx(DropdownItem, { id: node.id, children: node.name }, node.id));
            });
        return nodeDropDown;
    };
    const onTriggerClick = () => {
        setModalTitle("Node trigger workflow");
        driver
            .handleNodeTrigger(workflowInstanceData, selectedNode)
            .then(() => {
            setTitleType("success");
            setModalContent(`The node ${selectedNode.name} was triggered successfully`);
        })
            .catch((error) => {
            setTitleType("failure");
            setModalContent(`The node ${selectedNode.name} trigger failed. ErrorMessage : ${error.message}`);
        })
            .finally(() => {
            handleModalToggle();
        });
    };
    const errorModalAction = [
        _jsx(Button, { variant: "primary", onClick: handleModalToggle, children: "OK" }, "confirm-selection"),
    ];
    return (_jsxs(_Fragment, { children: [_jsx(WorkflowDetailsErrorModal, { errorString: modalContent, errorModalOpen: isModalOpen, errorModalAction: errorModalAction, handleErrorModal: handleModalToggle, label: "Node Trigger Error", title: setTitle(titleType, modalTitle) }), !isError ? (_jsxs(Card, { ...componentOuiaProps(ouiaId, "node-trigger", ouiaSafe), children: [_jsx(CardHeader, { children: _jsx(Title, { headingLevel: "h3", size: "xl", children: "Node Trigger" }) }), _jsx(CardHeader, { children: _jsx("div", { children: "Select a node from the workflow nodes list and click Trigger to launch it manually." }) }), _jsxs(CardBody, { children: [_jsx("div", { children: _jsx(Dropdown, { direction: "up", onSelect: onSelect, toggle: _jsx(DropdownToggle, { id: "toggle-id", "data-testid": "toggle-id", onToggle: onToggle, toggleIndicator: CaretDownIcon, children: selectedNode ? selectedNode.name : "select a node" }), isOpen: isOpen, dropdownItems: createNodeDropDown() }) }), selectedNode && (_jsx(_Fragment, { children: _jsx("div", { className: "pf-u-mt-md", children: _jsxs(Flex, { direction: { default: "column" }, children: [_jsx(FlexItem, { children: _jsxs(TextContent, { children: [" ", _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Node name : " }) }), _jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.p, children: selectedNode.name }) })] })] }) }), _jsx(FlexItem, { children: _jsxs(TextContent, { children: [" ", _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Node type : " }) }), _jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.p, children: selectedNode.type }) })] })] }) }), _jsx(FlexItem, { children: _jsxs(TextContent, { children: [" ", _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Node id : " }) }), _jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.p, children: selectedNode.id }) })] })] }) })] }) }) })), _jsx("div", { className: "pf-u-mt-md", children: _jsx(Button, { variant: "secondary", onClick: onTriggerClick, id: "trigger", "data-testid": "trigger", isDisabled: !selectedNode, children: "Trigger" }) })] })] })) : (_jsx(_Fragment, {}))] }));
};
export default WorkflowDetailsNodeTrigger;
//# sourceMappingURL=WorkflowDetailsNodeTrigger.js.map