import { jsx as _jsx } from "react/jsx-runtime";
import { useMemo, useState } from "react";
import { Dropdown, DropdownItem, KebabToggle } from "@patternfly/react-core/dist/js/components/Dropdown";
import { WorkflowInstanceState } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { checkWorkflowInstanceState } from "../utils/WorkflowListUtils";
const WorkflowListActionsKebab = ({ workflowInstance, onSkipClick, onRetryClick, onAbortClick, onOpenTriggerCloudEvent, ouiaId, ouiaSafe, }) => {
    const [isKebabOpen, setIsKebabOpen] = useState(false);
    const onSelect = () => {
        setIsKebabOpen(!isKebabOpen);
    };
    const onToggle = (isOpen) => {
        setIsKebabOpen(isOpen);
    };
    const dropDownList = useMemo(() => {
        const result = [];
        if (workflowInstance.state === WorkflowInstanceState.Error) {
            result.push(_jsx(DropdownItem, { onClick: () => onRetryClick(workflowInstance), children: "Retry" }, "Retry"));
            result.push(_jsx(DropdownItem, { onClick: () => onSkipClick(workflowInstance), children: "Skip" }, "Skip"));
        }
        if (onOpenTriggerCloudEvent) {
            result.push(_jsx(DropdownItem, { onClick: () => onOpenTriggerCloudEvent(workflowInstance), children: "Send Cloud Event" }, "CloudEvent"));
        }
        result.push(_jsx(DropdownItem, { onClick: () => onAbortClick(workflowInstance), children: "Abort" }, "Abort"));
        return result;
    }, [workflowInstance, onSkipClick, onRetryClick, onAbortClick, onOpenTriggerCloudEvent]);
    return (_jsx(Dropdown, { onSelect: onSelect, toggle: _jsx(KebabToggle, { isDisabled: checkWorkflowInstanceState(workflowInstance), onToggle: onToggle, id: "kebab-toggle" }), isOpen: isKebabOpen, isPlain: true, position: "right", "aria-label": "workflow instance actions dropdown", "aria-labelledby": "workflow instance actions dropdown", dropdownItems: dropDownList, ...componentOuiaProps(ouiaId, "workflow-list-actions-kebab", ouiaSafe) }));
};
export default WorkflowListActionsKebab;
//# sourceMappingURL=WorkflowListActionsKebab.js.map