"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.callK8sApiServer = callK8sApiServer;
var jsYaml = require("js-yaml");
var common_1 = require("./common");
var cors_proxy_api_1 = require("@kie-tools/cors-proxy-api");
function callK8sApiServer(args) {
    return __awaiter(this, void 0, void 0, function () {
        var apiCalls, results, apiCalls_1, apiCalls_1_1, apiCall, endpointUrl, interpolatedPathname, _a, _b, e_1_1;
        var e_1, _c, _d;
        var _e, _f;
        return __generator(this, function (_g) {
            switch (_g.label) {
                case 0:
                    apiCalls = args.k8sResourceYamls.map(function (yamlDocument) {
                        var _a, _b, _c;
                        var rawEndpoints = (_a = args.k8sApiServerEndpointsByResourceKind
                            .get(yamlDocument.kind)) === null || _a === void 0 ? void 0 : _a.get((_b = yamlDocument.apiVersion) !== null && _b !== void 0 ? _b : "v1");
                        if (!rawEndpoints) {
                            throw new Error("Can't create '".concat(yamlDocument.kind, "' because there's no matching API for it registered on '").concat(args.k8sApiServerUrl, "'"));
                        }
                        var rawEndpoint = (_c = rawEndpoints === null || rawEndpoints === void 0 ? void 0 : rawEndpoints.url.namespaced) !== null && _c !== void 0 ? _c : rawEndpoints === null || rawEndpoints === void 0 ? void 0 : rawEndpoints.url.global;
                        return {
                            kind: yamlDocument.kind,
                            yaml: yamlDocument,
                            rawEndpoint: rawEndpoint,
                        };
                    });
                    (0, common_1.consoleDebugMessage)("Done.");
                    (0, common_1.consoleDebugMessage)("");
                    (0, common_1.consoleDebugMessage)("Start calling API endpoints for each parsed YAML...");
                    results = [];
                    _g.label = 1;
                case 1:
                    _g.trys.push([1, 6, 7, 8]);
                    apiCalls_1 = __values(apiCalls), apiCalls_1_1 = apiCalls_1.next();
                    _g.label = 2;
                case 2:
                    if (!!apiCalls_1_1.done) return [3, 5];
                    apiCall = apiCalls_1_1.value;
                    endpointUrl = new URL(apiCall.rawEndpoint);
                    interpolatedPathname = endpointUrl.pathname.replace(":namespace", (_f = (_e = apiCall.yaml.metadata) === null || _e === void 0 ? void 0 : _e.namespace) !== null && _f !== void 0 ? _f : args.k8sNamespace);
                    endpointUrl.pathname = interpolatedPathname;
                    (0, common_1.consoleDebugMessage)("Creating '".concat(apiCall.kind, "' with POST ").concat(endpointUrl.toString()));
                    _b = (_a = results).push;
                    return [4, fetch(endpointUrl.toString(), {
                            headers: __assign({ Authorization: "Bearer ".concat(args.k8sServiceAccountToken), "Content-Type": "application/yaml" }, (args.insecurelyDisableTlsCertificateValidation
                                ? (_d = {},
                                    _d[cors_proxy_api_1.CorsProxyHeaderKeys.INSECURELY_DISABLE_TLS_CERTIFICATE_VALIDATION] = Boolean(args.insecurelyDisableTlsCertificateValidation).toString(),
                                    _d) : {})),
                            method: "POST",
                            body: jsYaml.dump(apiCall.yaml),
                        }).then(function (response) { return response.json(); })];
                case 3:
                    _b.apply(_a, [_g.sent()]);
                    _g.label = 4;
                case 4:
                    apiCalls_1_1 = apiCalls_1.next();
                    return [3, 2];
                case 5: return [3, 8];
                case 6:
                    e_1_1 = _g.sent();
                    e_1 = { error: e_1_1 };
                    return [3, 8];
                case 7:
                    try {
                        if (apiCalls_1_1 && !apiCalls_1_1.done && (_c = apiCalls_1.return)) _c.call(apiCalls_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                    return [7];
                case 8:
                    (0, common_1.consoleDebugMessage)("Done.");
                    return [2, results];
            }
        });
    });
}
//# sourceMappingURL=k8sApiServerCalls.js.map