import { MiningSchema, SupportVectorMachineModel } from "../../model/pmml4_4";
import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_EXPLANATION } from "./ModelExplanation";
import { MODEL_STATS } from "./ModelStats";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
import { TARGETS } from "./Targets";
export const SUPPORT_VECTOR_MACHINE_MODEL = `
elements.elements[(name = "SupportVectorMachineModel")] ~> $map(function($v, $i) {
  $merge([
    $supportVectorMachineModelFactory(),
    $v.attributes,
    {
      "_type": $v.name
    },
    {
      ${MINING_SCHEMA}, 
      ${OUTPUT},
      ${MODEL_STATS},
      ${MODEL_EXPLANATION},
      ${MODEL_VERIFICATION},
      ${TARGETS},
      ${LOCAL_TRANSFORMATIONS}
    }
  ])
})`;
export function supportVectorMachineModelFactory() {
    return new SupportVectorMachineModel({
        MiningSchema: new MiningSchema({ MiningField: [] }),
        SupportVectorMachine: [],
        VectorDictionary: { VectorFields: {} },
        functionName: "regression",
    });
}
//# sourceMappingURL=SupportVectorMachineModel.js.map