import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useState } from "react";
import { EmptyState, EmptyStateIcon, EmptyStateVariant, EmptyStateBody, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { ExclamationCircleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-circle-icon";
import { Redirect } from "react-router";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools/OuiaUtils";
export const PageNotFound = ({ ouiaId, ouiaSafe, ...props }) => {
    let prevPath;
    if (props.location.state !== undefined) {
        prevPath = props.location.state.prev;
    }
    else {
        prevPath = props.defaultPath;
    }
    const tempPath = prevPath === null || prevPath === void 0 ? void 0 : prevPath.split("/");
    prevPath = tempPath === null || tempPath === void 0 ? void 0 : tempPath.filter((item) => item);
    const [isRedirect, setIsredirect] = useState(false);
    const redirectHandler = () => {
        setIsredirect(true);
    };
    return (_jsxs(_Fragment, { children: [isRedirect && _jsx(Redirect, { to: `/${prevPath === null || prevPath === void 0 ? void 0 : prevPath[0]}` }), _jsx(PageSection, { variant: "light", ...componentOuiaProps(ouiaId, "page-not-found", ouiaSafe ? ouiaSafe : !isRedirect), children: _jsx(Bullseye, { children: _jsxs(EmptyState, { variant: EmptyStateVariant.full, children: [_jsx(EmptyStateIcon, { icon: ExclamationCircleIcon, color: "var(--pf-global--danger-color--100)" }), _jsx(Title, { headingLevel: "h1", size: "4xl", children: "404 Error: page not found" }), _jsx(EmptyStateBody, { children: "This page could not be found." }), _jsx(Button, { variant: "primary", onClick: redirectHandler, "data-testid": "redirect-button", children: props.defaultButton })] }) }) })] }));
};
//# sourceMappingURL=PageNotFound.js.map