import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useEffect, useRef, useState } from "react";
import { CSSTransition, SwitchTransition } from "react-transition-group";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Alert } from "@patternfly/react-core/dist/js/components/Alert";
import { SortIcon } from "@patternfly/react-icons/dist/js/icons/sort-icon";
import { PlusIcon } from "@patternfly/react-icons/dist/js/icons/plus-icon";
import { BoltIcon } from "@patternfly/react-icons/dist/js/icons/bolt-icon";
import DataTypeItem from "../DataTypeItem/DataTypeItem";
import MultipleDataTypeAdd from "../MultipleDataTypeAdd/MultipleDataTypeAdd";
import DataTypesSort from "../DataTypesSort/DataTypesSort";
import EmptyDataDictionary from "../EmptyDataDictionary/EmptyDataDictionary";
import { findIncrementalName } from "../../../PMMLModelHelper";
import "./DataDictionaryContainer.scss";
import DataDictionaryPropertiesEdit from "../DataDictionaryPropertiesEdit/DataDictionaryPropertiesEdit";
import { isEqual } from "lodash";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
const DataDictionaryContainer = (props) => {
    const { dataDictionary, onAdd, onEdit, onDelete, onReorder, onBatchAdd, onEditingPhaseChange } = props;
    const [dataTypes, setDataTypes] = useState(dataDictionary);
    const [editing, setEditing] = useState();
    const [viewSection, setViewSection] = useState("main");
    const [editingDataType, setEditingDataType] = useState();
    const [sorting, setSorting] = useState(false);
    const [dataTypeFocusIndex, setDataTypeFocusIndex] = useState(undefined);
    useEffect(() => {
        if (editing === dataDictionary.length) {
            setEditing(undefined);
            if (viewSection !== "main") {
                setViewSection("main");
            }
            onEditingPhaseChange(false);
        }
        if (viewSection === "properties" && editing !== undefined) {
            setEditingDataType(dataDictionary[editing]);
        }
        setDataTypes(dataDictionary);
    }, [dataDictionary, editing, viewSection]);
    const handleOutsideClick = () => {
        setEditing(undefined);
        onEditingPhaseChange(false);
    };
    const addDataType = () => {
        onAdd(findIncrementalName("New Data Type", dataTypes.map((dt) => dt.name), 1), "string", "categorical");
        setEditing(dataTypes.length);
        onEditingPhaseChange(true);
    };
    const saveDataType = (dataType, index) => {
        onEdit(index, dataTypes[index].name, dataType);
    };
    const handleSave = (dataType, index) => {
        saveDataType(dataType, index);
    };
    const handleDelete = (index, interaction) => {
        var _a;
        onDelete(index);
        if (interaction === "mouse") {
            if (document.activeElement instanceof HTMLElement) {
                (_a = document.activeElement) === null || _a === void 0 ? void 0 : _a.blur();
            }
        }
        else if (interaction === "keyboard") {
            setDataTypeFocusIndex(index);
        }
        setEditing(undefined);
        onEditingPhaseChange(false);
    };
    const handleEdit = (index) => {
        setEditing(index);
        onEditingPhaseChange(true);
    };
    const handleMultipleAdd = (fields) => {
        const fieldsNames = fields.split("\n").filter((item) => item.trim().length > 0);
        onBatchAdd(fieldsNames);
        setViewSection("main");
    };
    const handleConstraintsEdit = (dataType) => {
        if (editing !== undefined) {
            setEditingDataType(dataType);
            setViewSection("properties");
            onEditingPhaseChange(true);
        }
    };
    const handleConstraintsSave = (payload) => {
        if (editing !== undefined) {
            onEdit(editing, dataTypes[editing].name, payload);
        }
    };
    const handlePropertiesSave = (payload) => {
        if (editing !== undefined) {
            const dataType = dataTypes[editing];
            const existingPartial = {};
            Object.keys(payload).forEach((key) => Reflect.set(existingPartial, key, Reflect.get(dataType, key)));
            if (!isEqual(payload, existingPartial)) {
                onEdit(editing, dataType.name, Object.assign(dataType, payload));
            }
        }
    };
    const exitFromPropertiesEdit = () => {
        setViewSection("main");
    };
    const toggleSorting = () => {
        setEditing(undefined);
        setSorting(!sorting);
    };
    const dataTypeNameValidation = (dataTypeName) => {
        let isValid = true;
        if (dataTypeName.trim().length === 0) {
            return false;
        }
        const match = dataTypes.find((item, index) => item.name === dataTypeName.trim() && index !== editing);
        if (match !== undefined) {
            isValid = false;
        }
        return isValid;
    };
    const getTransition = (currentState) => {
        if (currentState === "main") {
            return "data-dictionary__overview";
        }
        else if (currentState === "batch-add") {
            return "enter-from-above";
        }
        else {
            return "enter-from-right";
        }
    };
    const { validationRegistry } = useValidationRegistry();
    const validations = useRef(validationRegistry.get(Builder().forDataDictionary().build()));
    useEffect(() => {
        if (editing === undefined) {
            validations.current = validationRegistry.get(Builder().forDataDictionary().build());
        }
    }, [dataDictionary, editing]);
    useEffect(() => {
        var _a;
        if (dataTypeFocusIndex !== undefined) {
            (_a = document.querySelector(`#data-type-item-n${dataTypeFocusIndex}`)) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [dataDictionary, dataTypeFocusIndex]);
    return (_jsx("div", { className: "data-dictionary", "data-testid": "data-dictionary-container", children: _jsx(SwitchTransition, { mode: "out-in", children: _jsx(CSSTransition, { timeout: {
                    enter: 230,
                    exit: 100,
                }, classNames: getTransition(viewSection), children: _jsxs(_Fragment, { children: [viewSection === "main" && (_jsxs("section", { className: "data-dictionary__overview", children: [_jsxs(Flex, { className: "data-dictionary__toolbar", "data-ouia-component-id": "dd-toolbar", children: [_jsx(FlexItem, { children: _jsx(Button, { variant: "primary", onClick: (event) => {
                                                    event.stopPropagation();
                                                    event.preventDefault();
                                                    addDataType();
                                                }, icon: _jsx(PlusIcon, {}), iconPosition: "left", isDisabled: editing !== undefined || sorting, ouiaId: "add-data-type", children: "Add Data Type" }) }), _jsx(FlexItem, { children: _jsx(Button, { variant: "secondary", onClick: () => setViewSection("batch-add"), icon: _jsx(BoltIcon, {}), iconPosition: "left", isDisabled: editing !== undefined || sorting, ouiaId: "add-multiple-data-type", children: "Add Multiple Data Types" }) }), _jsx(FlexItem, { align: { default: "alignRight" }, children: _jsx(Button, { variant: sorting ? "primary" : "secondary", onClick: toggleSorting, icon: _jsx(SortIcon, {}), iconPosition: "left", isDisabled: editing !== undefined, ouiaId: "order-toggle", children: sorting ? "End Ordering" : "Order" }) })] }), !sorting && (_jsxs(_Fragment, { children: [validations.current && validations.current.length > 0 && (_jsx("section", { className: "data-dictionary__validation-alert", children: _jsx(Alert, { variant: "warning", isInline: true, title: "Some items are invalid and need attention." }) })), _jsxs("section", { className: "data-dictionary__types-list", "data-ouia-component-id": "dd-types-list", children: [dataTypes.length === 0 && (_jsx(Bullseye, { style: { height: "40vh" }, children: _jsx(EmptyDataDictionary, {}) })), dataTypes.map((item, index) => (_jsx(DataTypeItem, { dataType: item, editingIndex: editing, index: index, onSave: handleSave, onEdit: handleEdit, onDelete: handleDelete, onConstraintsEdit: handleConstraintsEdit, onConstraintsSave: handleConstraintsSave, onValidate: dataTypeNameValidation, onOutsideClick: handleOutsideClick }, index)))] })] })), sorting && (_jsx("section", { className: "data-dictionary__types-list", children: _jsx(DataTypesSort, { dataTypes: dataTypes, onReorder: onReorder }) }))] })), viewSection === "batch-add" && (_jsx(MultipleDataTypeAdd, { onAdd: handleMultipleAdd, onCancel: () => setViewSection("main") })), viewSection === "properties" && (_jsx(DataDictionaryPropertiesEdit, { dataType: editingDataType, dataFieldIndex: editing, onClose: exitFromPropertiesEdit, onSave: handlePropertiesSave }))] }) }, viewSection) }) }));
};
export default DataDictionaryContainer;
export var ConstraintType;
(function (ConstraintType) {
    ConstraintType["RANGE"] = "Range";
    ConstraintType["ENUMERATION"] = "Enumeration";
    ConstraintType["NONE"] = "";
})(ConstraintType || (ConstraintType = {}));
//# sourceMappingURL=DataDictionaryContainer.js.map