import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import "./AttributesTableRow.scss";
import { AttributeLabels, AttributesTableAction } from "../atoms";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
import { ValidationIndicatorLabel } from "../../EditorCore/atoms";
import { toText } from "../organisms";
export const AttributesTableRow = (props) => {
    const { modelIndex, characteristicIndex, characteristic, attributeIndex, attribute, areReasonCodesUsed, characteristicReasonCode, dataFields, miningFields, onEdit, onDelete, onCommit, } = props;
    const { validationRegistry } = useValidationRegistry();
    const validations = useMemo(() => validationRegistry.get(Builder()
        .forModel(modelIndex)
        .forCharacteristics()
        .forCharacteristic(characteristicIndex)
        .forAttribute(attributeIndex)
        .forPredicate()
        .build()), [modelIndex, characteristicIndex, attributeIndex, attribute, miningFields]);
    const handleEdit = (event) => {
        event.preventDefault();
        event.stopPropagation();
        onEdit();
    };
    return (_jsx("article", { id: `attribute-n${attributeIndex}`, "data-testid": `attribute-n${attributeIndex}`, className: "attribute-item", onClick: () => onEdit(), onKeyDown: (e) => {
            if (e.key === "Enter") {
                handleEdit(e);
            }
        }, "data-ouia-component-type": "attribute-item", tabIndex: 0, children: _jsxs(Split, { hasGutter: true, style: { height: "100%" }, children: [_jsx(SplitItem, { children: _jsxs(_Fragment, { children: [validations.length > 0 && (_jsx(ValidationIndicatorLabel, { validations: validations, cssClass: "characteristic-list__item__label", children: _jsxs(_Fragment, { children: [attribute.predicate && _jsx("pre", { children: toText(attribute.predicate, dataFields) }), !attribute.predicate && (_jsxs(_Fragment, { children: [_jsx("strong", { children: "Predicate:" }), "\u00A0", _jsx("em", { children: "Missing" })] }))] }) })), validations.length === 0 && (_jsx(Label, { tabIndex: 0, color: "blue", onClose: (e) => {
                                    e.nativeEvent.stopImmediatePropagation();
                                    e.stopPropagation();
                                    onCommit({ predicate: undefined });
                                }, children: _jsx("pre", { children: toText(attribute.predicate, dataFields) }) }))] }) }), _jsx(SplitItem, { isFilled: true, children: _jsx(AttributeLabels, { modelIndex: modelIndex, characteristicIndex: characteristicIndex, characteristic: characteristic, activeAttributeIndex: attributeIndex, activeAttribute: attribute, areReasonCodesUsed: areReasonCodesUsed, characteristicReasonCode: characteristicReasonCode, commit: onCommit }) }), _jsx(SplitItem, { children: _jsx(AttributesTableAction, { index: attributeIndex, onDelete: onDelete }) })] }) }));
};
//# sourceMappingURL=AttributesTableRow.js.map