import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useRef, useState } from "react";
import { Form } from "@patternfly/react-core/dist/js/components/Form";
import { CharacteristicsTableEditRow, CharacteristicsTableRow } from "../molecules";
import { Operation } from "../Operation";
import { useSelector } from "react-redux";
import { useOperation } from "../OperationContext";
export const CharacteristicsTable = (props) => {
    const { modelIndex, areReasonCodesUsed, scorecardBaselineScore, characteristics, characteristicsUnfilteredLength, selectedCharacteristicIndex, setSelectedCharacteristicIndex, validateCharacteristicName, viewAttribute, deleteCharacteristic, onAddAttribute, onCommitAndClose, onCommit, onCancel, } = props;
    const addCharacteristicRowRef = useRef(null);
    const [characteristicFocusIndex, setCharacteristicFocusIndex] = useState(undefined);
    const { activeOperation, setActiveOperation } = useOperation();
    const dataFields = useSelector((state) => {
        return state.DataDictionary.DataField;
    });
    useEffect(() => {
        if (activeOperation === Operation.UPDATE_CHARACTERISTIC && addCharacteristicRowRef.current) {
            addCharacteristicRowRef.current.scrollIntoView({ behavior: "smooth" });
        }
    }, [activeOperation]);
    useEffect(() => {
        if (selectedCharacteristicIndex === characteristicsUnfilteredLength) {
            setSelectedCharacteristicIndex(undefined);
            setActiveOperation(Operation.NONE);
        }
    }, [characteristics, selectedCharacteristicIndex]);
    useEffect(() => {
        var _a;
        if (characteristicFocusIndex !== undefined) {
            (_a = document.querySelector(`#characteristic-n${characteristicFocusIndex}`)) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [characteristics, characteristicFocusIndex]);
    const onEdit = (index) => {
        setSelectedCharacteristicIndex(index);
        setActiveOperation(Operation.UPDATE_CHARACTERISTIC);
    };
    const handleDelete = (index, interaction) => {
        var _a;
        onDelete(index);
        if (interaction === "mouse") {
            if (document.activeElement instanceof HTMLElement) {
                (_a = document.activeElement) === null || _a === void 0 ? void 0 : _a.blur();
            }
        }
        else if (interaction === "keyboard") {
            setCharacteristicFocusIndex(index);
        }
        setSelectedCharacteristicIndex(undefined);
    };
    const onDelete = (index) => {
        if (index !== undefined) {
            setActiveOperation(Operation.NONE);
            deleteCharacteristic(index);
        }
    };
    const onValidateCharacteristicName = (index, name) => {
        return validateCharacteristicName(index, name);
    };
    return (_jsx(Form, { "data-testid": "characteristics-table", onSubmit: (e) => {
            e.stopPropagation();
            e.preventDefault();
        }, className: "characteristics-container__overview__form", children: characteristics.map((ic) => {
            const isRowInEditMode = selectedCharacteristicIndex === ic.index && activeOperation === Operation.UPDATE_CHARACTERISTIC;
            return (_jsxs("article", { className: `editable-item characteristic-item-n${selectedCharacteristicIndex} ${isRowInEditMode ? "editable-item--editing" : ""}`, children: [isRowInEditMode && (_jsx("div", { ref: addCharacteristicRowRef, children: _jsx(CharacteristicsTableEditRow, { modelIndex: modelIndex, areReasonCodesUsed: areReasonCodesUsed, scorecardBaselineScore: scorecardBaselineScore, characteristic: ic, validateCharacteristicName: (_name) => onValidateCharacteristicName(ic.index, _name), viewAttribute: viewAttribute, onAddAttribute: onAddAttribute, onCommitAndClose: onCommitAndClose, onCommit: onCommit, onCancel: onCancel }) })), !isRowInEditMode && (_jsx(CharacteristicsTableRow, { modelIndex: modelIndex, characteristicIndex: ic.index, areReasonCodesUsed: areReasonCodesUsed, scorecardBaselineScore: scorecardBaselineScore, characteristic: ic, dataFields: dataFields, onEdit: () => onEdit(ic.index), onDelete: (interaction) => handleDelete(ic.index, interaction) }))] }, ic.index));
        }) }));
};
//# sourceMappingURL=CharacteristicsTable.js.map