import { jsx as _jsx } from "react/jsx-runtime";
import { LinearRegressionView, Range } from "./LinearRegressionView";
import { useSelector } from "react-redux";
export const LinearRegressionViewAdaptor = (props) => {
    const { model } = props;
    const dataDictionary = useSelector((state) => state.DataDictionary);
    const table = getRegressionTable(model);
    if (table === undefined) {
        return _jsx("div", { children: "Unsupported" });
    }
    const numericPredictor = getNumericPredictorType(table);
    if (numericPredictor === undefined) {
        return _jsx("div", { children: "Unsupported" });
    }
    const modelName = model.modelName;
    const miningSchema = model.MiningSchema;
    const dependentAxisTitle = miningSchema.MiningField.filter((mf) => mf.usageType === "target")[0].name;
    const lines = getLines(table, numericPredictor);
    let rangeY = getYRange(dataDictionary, model);
    if (rangeY === undefined) {
        rangeY = getDefaultYRange(lines);
    }
    let rangeX = getXRange(dataDictionary, numericPredictor);
    if (rangeX === undefined) {
        rangeX = getDefaultXRange(lines, rangeY);
    }
    return (_jsx("div", { children: _jsx(LinearRegressionView, { modelName: modelName !== null && modelName !== void 0 ? modelName : "<Undefined>", independentAxisTitle: numericPredictor.name, dependentAxisTitle: dependentAxisTitle, lines: lines, rangeX: rangeX, rangeY: rangeY }) }));
};
const getRegressionTable = (model) => {
    const tables = model.RegressionTable;
    if (tables === undefined || tables.length > 1) {
        return undefined;
    }
    return tables[0];
};
const getNumericPredictorType = (table) => {
    const predicates = table.NumericPredictor;
    if (predicates === undefined || predicates.length > 1) {
        return undefined;
    }
    return predicates[0];
};
const getLines = (table, numericPredictor) => {
    const c = table.intercept;
    const line = { m: numericPredictor.coefficient, c: c, title: "base" };
    const lines = new Array(line);
    const categoricalPredictors = table.CategoricalPredictor;
    if (categoricalPredictors === undefined) {
        return lines;
    }
    categoricalPredictors.forEach((cp) => {
        lines.push({ m: line.m, c: line.c + cp.coefficient, title: `${line.title} (${cp.value})` });
    });
    return lines;
};
const getYRange = (dataDictionary, model) => {
    const targetField = getTargetMiningField(model);
    if (targetField === undefined) {
        return undefined;
    }
    const targetFieldIntervals = getMiningFieldIntervals(dataDictionary, targetField.name);
    return getIntervalsMaximumRange(targetFieldIntervals);
};
const getTargetMiningField = (model) => {
    const targetFields = model.MiningSchema.MiningField.filter((mf) => mf.usageType === "target");
    if (targetFields === undefined || targetFields.length !== 1) {
        return undefined;
    }
    return targetFields[0];
};
const getXRange = (dataDictionary, numericPredictor) => {
    const predictorFieldIntervals = getMiningFieldIntervals(dataDictionary, numericPredictor.name);
    return getIntervalsMaximumRange(predictorFieldIntervals);
};
const getMiningFieldIntervals = (dataDictionary, fieldName) => {
    const dataFields = dataDictionary.DataField.filter((df) => df.name === fieldName && df.optype === "continuous");
    if (dataFields === undefined || dataFields.length !== 1) {
        return [];
    }
    const intervals = dataFields[0].Interval;
    if (intervals === undefined) {
        return [];
    }
    return intervals;
};
const getIntervalsMaximumRange = (intervals) => {
    if (intervals.length === 0) {
        return undefined;
    }
    const min = intervals.map((interval) => { var _a; return (_a = interval.leftMargin) !== null && _a !== void 0 ? _a : 0; }).reduce((pv, cv) => Math.min(pv, cv));
    const max = intervals.map((interval) => { var _a; return (_a = interval.rightMargin) !== null && _a !== void 0 ? _a : 0; }).reduce((pv, cv) => Math.max(pv, cv));
    return new Range(min, max);
};
const getDefaultYRange = (lines) => {
    const maxIntersect = Math.max(...lines.map((line) => line.c));
    const defaultMaxY = maxIntersect * 2;
    const defaultMinY = -defaultMaxY;
    return new Range(defaultMinY, defaultMaxY);
};
const getDefaultXRange = (lines, rangeY) => {
    const minGradient = Math.min(...lines.map((line) => line.m));
    const maxIntersect = Math.max(...lines.map((line) => line.c));
    const defaultMaxX = (rangeY.max - maxIntersect) / minGradient;
    const defaultMinX = -defaultMaxX;
    return new Range(defaultMinX, defaultMaxX);
};
//# sourceMappingURL=LinearRegressionViewAdaptor.js.map