import { jsxs as _jsxs, jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo } from "react";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { ArrowAltCircleRightIcon } from "@patternfly/react-icons/dist/js/icons/arrow-alt-circle-right-icon";
import "./MiningSchemaFieldLabels.scss";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
import { ValidationIndicatorLabel } from "../../EditorCore/atoms";
import { areLowHighValuesRequired, isInvalidValueReplacementRequired, isMissingValueReplacementRequired, } from "../../../validation/MiningSchema";
const MiningSchemaFieldLabels = (props) => {
    const { index, modelIndex, field, onEdit, onDelete, editing } = props;
    const BasicMiningLabel = (name, value, onClose) => {
        return (_jsxs(Label, { color: "cyan", className: "mining-schema-list__item__label", closeBtnProps: { className: "ignore-onclickoutside" }, onClose: editing ? onClose : undefined, "data-ouia-component-id": name, "data-ouia-component-type": "mining-label", children: [_jsxs("strong", { children: [name, ":"] }), "\u00A0", _jsx("span", { children: value })] }));
    };
    const InvalidMiningLabel = (name, value, onClose, validations) => {
        return (_jsxs(ValidationIndicatorLabel, { validations: validations, cssClass: "mining-schema-list__item__label", onClose: editing ? onClose : undefined, children: [_jsxs("strong", { children: [name, ":"] }), "\u00A0", _jsx("span", { children: value })] }));
    };
    const MissingValueAwareMiningLabel = (name, value, isValueRequired, validations, onClose) => {
        return (_jsxs(_Fragment, { children: [isValueRequired && value !== undefined && BasicMiningLabel(name, value, onClose), isValueRequired && value === undefined && InvalidMiningLabel(name, _jsx("em", { children: "Missing" }), undefined, validations), !isValueRequired && value !== undefined && InvalidMiningLabel(name, value, onClose, validations)] }));
    };
    const { validationRegistry } = useValidationRegistry();
    const validationsImportance = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forMiningSchema().forMiningField(index).forImportance().build()), [modelIndex, index, field]);
    const validationsLowValue = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forMiningSchema().forMiningField(index).forLowValue().build()), [modelIndex, index, field]);
    const validationsHighValue = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forMiningSchema().forMiningField(index).forHighValue().build()), [modelIndex, index, field]);
    const _areLowHighValuesRequired = useMemo(() => areLowHighValuesRequired(field.outliers), [modelIndex, index, field]);
    const validationsMissingValueReplacement = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forMiningSchema().forMiningField(index).forMissingValueReplacement().build()), [modelIndex, index, field]);
    const _isMissingValueReplacementRequired = useMemo(() => isMissingValueReplacementRequired(field.missingValueTreatment), [modelIndex, index, field]);
    const validationsInvalidValueReplacement = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forMiningSchema().forMiningField(index).forInvalidValueReplacement().build()), [modelIndex, index, field]);
    const _isInvalidValueReplacementRequired = useMemo(() => isInvalidValueReplacementRequired(field.invalidValueTreatment), [modelIndex, index, field]);
    return (_jsxs(_Fragment, { children: [field.usageType !== undefined &&
                BasicMiningLabel("Usage Type", field.usageType, () => onDelete({
                    ...field,
                    usageType: undefined,
                })), field.optype !== undefined &&
                BasicMiningLabel("Op Type", field.optype, () => onDelete({
                    ...field,
                    optype: undefined,
                })), field.importance !== undefined && (_jsxs(_Fragment, { children: [validationsImportance.length === 0 &&
                        BasicMiningLabel("Importance", field.importance, () => onDelete({
                            ...field,
                            importance: undefined,
                        })), validationsImportance.length > 0 &&
                        InvalidMiningLabel("Importance", field.importance, () => onDelete({ ...field, importance: undefined }), validationsImportance)] })), field.outliers !== undefined &&
                BasicMiningLabel("Outliers", field.outliers, () => onDelete({
                    ...field,
                    outliers: undefined,
                })), MissingValueAwareMiningLabel("Low Value", field.lowValue, _areLowHighValuesRequired, validationsLowValue, () => onDelete({
                ...field,
                lowValue: undefined,
            })), MissingValueAwareMiningLabel("High Value", field.highValue, _areLowHighValuesRequired, validationsHighValue, () => onDelete({
                ...field,
                highValue: undefined,
            })), field.missingValueTreatment !== undefined &&
                BasicMiningLabel("Missing Value Treatment", field.missingValueTreatment, () => onDelete({
                    ...field,
                    missingValueTreatment: undefined,
                })), MissingValueAwareMiningLabel("Missing Value Replacement", field.missingValueReplacement, _isMissingValueReplacementRequired, validationsMissingValueReplacement, () => onDelete({
                ...field,
                missingValueReplacement: undefined,
            })), field.invalidValueTreatment !== undefined &&
                BasicMiningLabel("Invalid Value Treatment", field.invalidValueTreatment, () => onDelete({
                    ...field,
                    invalidValueTreatment: undefined,
                })), MissingValueAwareMiningLabel("Invalid Value Replacement", field.invalidValueReplacement, _isInvalidValueReplacementRequired, validationsInvalidValueReplacement, () => onDelete({
                ...field,
                invalidValueReplacement: undefined,
            })), editing && (_jsx(Label, { className: "mining-schema-list__item__label", variant: "outline", color: "cyan", href: "#", icon: _jsx(ArrowAltCircleRightIcon, {}), onClick: (event) => {
                    event.preventDefault();
                    onEdit();
                }, "data-ouia-component-id": "edit-properties", "data-ouia-component-type": "mf-label", children: "Edit Properties" }))] }));
};
export default MiningSchemaFieldLabels;
//# sourceMappingURL=MiningSchemaFieldLabels.js.map