import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useContext, useMemo } from "react";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { TrashIcon } from "@patternfly/react-icons/dist/js/icons/trash-icon";
import { MiningSchemaContext } from "../MiningSchemaContainer/MiningSchemaContainer";
import useOnclickOutside from "react-cool-onclickoutside";
import MiningSchemaFieldLabels from "../MiningSchemaFieldLabels/MiningSchemaFieldLabels";
import "./MiningSchemaFields.scss";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
import { ValidationIndicator } from "../../EditorCore/atoms";
const MiningSchemaFields = ({ modelIndex, dataDictionary, fields, onAddProperties, onDelete, onPropertyDelete, onEdit, onCancel, }) => {
    return (_jsx("ul", { className: "mining-schema-list", "data-ouia-component-type": "mining-schema-list", children: fields === null || fields === void 0 ? void 0 : fields.map((field, index) => {
            return (_jsx(MiningSchemaItem, { dataDictionary: dataDictionary, field: field, index: index, modelIndex: modelIndex, onAddProperties: onAddProperties, onDelete: onDelete, onPropertyDelete: onPropertyDelete, onEdit: onEdit, onCancel: onCancel }, field.name));
        }) }));
};
export default MiningSchemaFields;
const MiningSchemaItem = (props) => {
    const { index, modelIndex, dataDictionary, field, onAddProperties, onDelete, onPropertyDelete, onEdit, onCancel } = props;
    const editing = useContext(MiningSchemaContext);
    const ref = useOnclickOutside(() => {
        onCancel();
    }, {
        disabled: editing !== index,
        eventTypes: ["click"],
    });
    const addProperties = () => {
        onAddProperties(index);
    };
    const deleteProperty = (updatedField) => {
        onPropertyDelete(index, updatedField);
    };
    const handleEdit = (event) => {
        event.preventDefault();
        event.stopPropagation();
        onEdit(index);
    };
    const handleDelete = (event, interaction) => {
        event.stopPropagation();
        event.preventDefault();
        if (onDelete) {
            onDelete(index, interaction);
        }
    };
    const { validationRegistry } = useValidationRegistry();
    const validations = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forMiningSchema().forMiningField(index).build()), [index, modelIndex, dataDictionary, field]);
    return (_jsxs(_Fragment, { children: [index === editing && (_jsx("li", { id: `mining-schema-field-n${index}`, "data-testid": `mining-schema-field-n${index}`, "data-ouia-component-id": field.name, "data-ouia-component-type": "edit-mining-field-row-", className: `editable-item ${editing === index ? "editable-item--editing" : ""}`, ref: ref, tabIndex: 0, onKeyDown: (event) => {
                    if (event.key === "Escape") {
                        onCancel();
                    }
                }, children: _jsx("section", { className: "editable-item__inner", children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx("span", { className: "mining-schema-list__item__name", children: field.name }) }), _jsx(SplitItem, { isFilled: true, children: _jsx(MiningSchemaFieldLabels, { modelIndex: modelIndex, index: index, field: field, onEdit: addProperties, onDelete: deleteProperty, editing: index === editing }) })] }) }) }, field.name)), index !== editing && (_jsx("li", { id: `mining-schema-field-n${index}`, "data-testid": `mining-schema-field-n${index}`, "data-ouia-component-id": field.name, "data-ouia-component-type": "mining-field-row", className: `editable-item ${editing === index ? "editable-item--editing" : ""}`, onClick: (event) => handleEdit(event), ref: ref, tabIndex: 0, onKeyDown: (event) => {
                    if (event.key === "Enter") {
                        handleEdit(event);
                    }
                    if (event.key === "Escape") {
                        onCancel();
                    }
                }, children: _jsx("section", { className: "editable-item__inner", children: _jsxs(Split, { hasGutter: true, children: [validations.length > 0 && (_jsx(SplitItem, { children: _jsx(Flex, { alignItems: { default: "alignItemsCenter" }, justifyContent: { default: "justifyContentCenter" }, style: { height: "100%" }, children: _jsx(FlexItem, { "data-ouia-component-id": "validation-issue", children: _jsx(ValidationIndicator, { validations: validations }) }) }) })), _jsx(SplitItem, { children: _jsx("span", { className: "mining-schema-list__item__name", children: field.name }) }), _jsx(SplitItem, { isFilled: true, children: _jsx(MiningSchemaFieldLabels, { modelIndex: modelIndex, index: index, field: field, onEdit: addProperties, onDelete: deleteProperty, editing: index === editing }) }), _jsx(SplitItem, { children: _jsx(Button, { id: `mining-schema-field-n${index}__delete`, "data-testid": `mining-schema-field-n${index}__delete`, ouiaId: "delete-field", className: "editable-item__delete", variant: "plain", onClick: (e) => handleDelete(e, "mouse"), onKeyDown: (event) => {
                                        if (event.key === "Enter") {
                                            handleDelete(event, "keyboard");
                                        }
                                    }, children: _jsx(TrashIcon, {}) }) })] }) }) }, field.name))] }));
};
//# sourceMappingURL=MiningSchemaFields.js.map