import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { ArrowAltCircleRightIcon } from "@patternfly/react-icons/dist/js/icons/arrow-alt-circle-right-icon";
import { OutputFieldLabel } from "./OutputFieldLabel";
import { ValidationIndicatorLabel } from "../../EditorCore/atoms";
const PADDING = { marginRight: "4px" };
export const OutputLabelsEditMode = (props) => {
    const { optype, setOptype, targetField, setTargetField, targetFieldValidation, feature, setFeature, value, setValue, rank, setRank, rankOrder, setRankOrder, segmentId, setSegmentId, isFinalResult, setIsFinalResult, commit, viewExtendedProperties, isDisabled, } = props;
    return (_jsxs(_Fragment, { children: [optype &&
                OutputFieldLabel("OpType", optype, () => {
                    setOptype(undefined);
                    commit({
                        optype: undefined,
                    });
                }), targetFieldValidation.length > 0 ? (_jsxs(ValidationIndicatorLabel, { validations: targetFieldValidation, cssClass: "output-fields-list__item__label", children: [_jsx("strong", { children: "TargetField:" }), "\u00A0", _jsx("em", { children: "Missing" })] })) : (targetField &&
                OutputFieldLabel("TargetField", targetField, () => {
                    setTargetField(undefined);
                    commit({
                        targetField: undefined,
                    });
                })), feature &&
                OutputFieldLabel("Feature", feature, () => {
                    setFeature(undefined);
                    commit({
                        feature: undefined,
                    });
                }), value &&
                OutputFieldLabel("Value", value, () => {
                    setValue(undefined);
                    commit({
                        value: undefined,
                    });
                }), rank !== undefined &&
                OutputFieldLabel("Rank", rank, () => {
                    setRank(undefined);
                    commit({
                        rank: undefined,
                    });
                }), rankOrder &&
                OutputFieldLabel("RankOrder", rankOrder, () => {
                    setRankOrder(undefined);
                    commit({
                        rankOrder: undefined,
                    });
                }), segmentId &&
                OutputFieldLabel("SegmentId", segmentId, () => {
                    setSegmentId(undefined);
                    commit({
                        segmentId: undefined,
                    });
                }), isFinalResult &&
                OutputFieldLabel("FinalResult", isFinalResult.toString(), () => {
                    setIsFinalResult(undefined);
                    commit({
                        isFinalResult: undefined,
                    });
                }), isDisabled && (_jsx(Label, { style: PADDING, variant: "outline", icon: _jsx(ArrowAltCircleRightIcon, {}), children: "Edit properties" })), !isDisabled && (_jsx(Label, { style: PADDING, variant: "outline", color: "cyan", href: "#outline", icon: _jsx(ArrowAltCircleRightIcon, {}), onClick: (e) => {
                    e.preventDefault();
                    viewExtendedProperties();
                }, children: "Edit properties" }))] }));
};
//# sourceMappingURL=OutputLabelsEditMode.js.map