import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo, useState } from "react";
import { isEqual } from "lodash";
import { CSSTransition, SwitchTransition } from "react-transition-group";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Alert } from "@patternfly/react-core/dist/js/components/Alert";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { ArrowAltCircleLeftIcon } from "@patternfly/react-icons/dist/js/icons/arrow-alt-circle-left-icon";
import { BoltIcon } from "@patternfly/react-icons/dist/js/icons/bolt-icon";
import { PlusIcon } from "@patternfly/react-icons/dist/js/icons/plus-icon";
import { Actions } from "../../../reducers";
import OutputFieldsTable from "./OutputFieldsTable";
import OutputsBatchAdd from "./OutputsBatchAdd";
import { Operation, useOperation } from "../../EditorScorecard";
import { OutputFieldExtendedProperties } from "./OutputFieldExtendedProperties";
import "./OutputsContainer.scss";
import { findIncrementalName } from "../../../PMMLModelHelper";
import { useBatchDispatch, useHistoryService } from "../../../history";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
var get = Reflect.get;
var set = Reflect.set;
export const OutputsContainer = (props) => {
    const { modelIndex, output, miningSchema, validateOutputFieldName, deleteOutputField, commitOutputField } = props;
    const [selectedOutputIndex, setSelectedOutputIndex] = useState(undefined);
    const [viewSection, setViewSection] = useState("overview");
    const { activeOperation, setActiveOperation } = useOperation();
    const { service, getCurrentState } = useHistoryService();
    const dispatch = useBatchDispatch(service, getCurrentState);
    const targetFields = useMemo(() => getMiningSchemaTargetFields(miningSchema), [miningSchema]);
    const editItem = useMemo(() => {
        if (selectedOutputIndex === undefined) {
            return undefined;
        }
        const outputs = output === null || output === void 0 ? void 0 : output.OutputField;
        if (outputs === undefined) {
            return undefined;
        }
        return outputs[selectedOutputIndex];
    }, [output, selectedOutputIndex]);
    const getTransition = (_viewSection) => {
        let cssClass;
        switch (_viewSection) {
            case "overview":
                cssClass = "outputs-container__overview";
                break;
            case "extended-properties":
                cssClass = "outputs-container__extended-properties";
                break;
            case "batch-add":
                cssClass = "outputs-container__batch-add";
                break;
        }
        return cssClass;
    };
    const addOutputField = () => {
        var _a;
        const numberOfOutputFields = output === null || output === void 0 ? void 0 : output.OutputField.length;
        if (numberOfOutputFields !== undefined) {
            const existingNames = (_a = output === null || output === void 0 ? void 0 : output.OutputField.map((of) => of.name.toString())) !== null && _a !== void 0 ? _a : [];
            const newOutputFieldName = findIncrementalName("New output", existingNames, 1);
            const newOutputField = {
                name: newOutputFieldName,
                dataType: "string",
                optype: undefined,
                targetField: undefined,
                feature: undefined,
                value: undefined,
                rank: undefined,
                rankOrder: undefined,
                segmentId: undefined,
                isFinalResult: undefined,
            };
            setSelectedOutputIndex(numberOfOutputFields);
            setActiveOperation(Operation.UPDATE_OUTPUT);
            commitOutputField(undefined, newOutputField);
        }
    };
    const addBatchOutputs = (outputs) => {
        const outputsNames = outputs.split("\n").filter((item) => item.trim().length > 0);
        dispatch({
            type: Actions.AddBatchOutputs,
            payload: {
                modelIndex: modelIndex,
                outputFields: outputsNames,
            },
        });
        setViewSection("overview");
    };
    const onCommitAndClose = () => {
        onCommit({});
        onCancel();
    };
    const onCommit = (partial) => {
        if (output !== undefined && selectedOutputIndex !== undefined) {
            const outputField = output.OutputField[selectedOutputIndex];
            const existingPartial = {};
            Object.keys(partial).forEach((key) => set(existingPartial, key, get(outputField, key)));
            if (!isEqual(partial, existingPartial)) {
                commitOutputField(selectedOutputIndex, { ...outputField, ...partial });
            }
        }
    };
    const onCancel = () => {
        setSelectedOutputIndex(undefined);
        setActiveOperation(Operation.NONE);
    };
    const { validationRegistry } = useValidationRegistry();
    const validations = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forOutput().build()), [modelIndex, output === null || output === void 0 ? void 0 : output.OutputField]);
    return (_jsx("div", { className: "outputs-container", children: _jsx(SwitchTransition, { mode: "out-in", children: _jsx(CSSTransition, { timeout: {
                    enter: 230,
                    exit: 100,
                }, classNames: getTransition(viewSection), children: _jsxs(_Fragment, { children: [viewSection === "overview" && (_jsxs(Stack, { hasGutter: true, className: "outputs-container__overview", children: [_jsx(StackItem, { children: _jsxs(Flex, { "data-ouia-component-id": "outputs-toolbar", children: [_jsx(FlexItem, { children: _jsx(Button, { variant: "primary", onClick: (e) => {
                                                        e.stopPropagation();
                                                        e.preventDefault();
                                                        addOutputField();
                                                    }, isDisabled: activeOperation !== Operation.NONE, icon: _jsx(PlusIcon, {}), iconPosition: "left", ouiaId: "add-output", children: "Add Output" }) }), _jsx(FlexItem, { children: _jsx(Button, { variant: "secondary", onClick: () => setViewSection("batch-add"), isDisabled: activeOperation !== Operation.NONE, icon: _jsx(BoltIcon, {}), iconPosition: "left", children: "Add Multiple Outputs" }) })] }) }), validations && validations.length > 0 && (_jsx(StackItem, { children: _jsx(Alert, { variant: "warning", isInline: true, title: (output === null || output === void 0 ? void 0 : output.OutputField.length)
                                            ? "Some items are invalid and need attention."
                                            : "At least one Output Field is required." }) })), _jsx(StackItem, { className: "outputs-container__fields-list", "data-ouia-component-id": "outputs-overview", children: _jsx(OutputFieldsTable, { modelIndex: modelIndex, outputs: output === null || output === void 0 ? void 0 : output.OutputField, selectedOutputIndex: selectedOutputIndex, setSelectedOutputIndex: setSelectedOutputIndex, validateOutputFieldName: validateOutputFieldName, viewExtendedProperties: () => setViewSection("extended-properties"), onAddOutputField: addOutputField, onDeleteOutputField: deleteOutputField, onCommitAndClose: onCommitAndClose, onCommit: onCommit, onCancel: onCancel }) })] })), viewSection === "extended-properties" && (_jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsx(TextContent, { children: _jsxs(Title, { size: "lg", headingLevel: "h1", children: [_jsx("a", { onClick: () => setViewSection("overview"), children: editItem === null || editItem === void 0 ? void 0 : editItem.name }), "\u00A0/\u00A0Properties"] }) }) }), _jsx(StackItem, { className: "outputs-container__extended-properties", children: _jsx(OutputFieldExtendedProperties, { modelIndex: modelIndex, activeOutputFieldIndex: selectedOutputIndex, activeOutputField: editItem, targetFields: targetFields, commit: onCommit }) }), _jsx(StackItem, { children: _jsx(Button, { variant: "primary", onClick: () => setViewSection("overview"), icon: _jsx(ArrowAltCircleLeftIcon, {}), iconPosition: "left", children: "Back" }) })] })), viewSection === "batch-add" && (_jsx(OutputsBatchAdd, { onAdd: addBatchOutputs, onCancel: () => setViewSection("overview") }))] }) }, viewSection) }) }));
};
const getMiningSchemaTargetFields = (miningSchema) => {
    return miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField.filter((field) => field.usageType === "target").map((field) => field.name);
};
//# sourceMappingURL=OutputsContainer.js.map