export class WorkflowDetailsGatewayApiImpl {
    constructor(queries) {
        this.listeners = [];
        this.handleWorkflowAbort = (workflowInstance) => {
            return this.queries.handleWorkflowAbort(workflowInstance);
        };
        this.cancelJob = (job) => {
            return this.queries.jobCancel(job);
        };
        this.rescheduleJob = (job, repeatInterval, repeatLimit, scheduleDate) => {
            return this.queries.rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate);
        };
        this.handleWorkflowVariableUpdate = (workflowInstance, updatedJson) => {
            return this.queries.handleWorkflowVariableUpdate(workflowInstance, updatedJson);
        };
        this.queries = queries;
        this._WorkflowDetailsState = { id: "" };
    }
    get workflowDetailsState() {
        return this._WorkflowDetailsState;
    }
    getTriggerableNodes(workflowInstance) {
        return this.queries.getTriggerableNodes(workflowInstance);
    }
    handleNodeTrigger(workflowInstance, node) {
        return this.queries.handleNodeTrigger(workflowInstance, node);
    }
    workflowDetailsQuery(id) {
        return new Promise((resolve, reject) => {
            this.queries
                .getWorkflowDetails(id)
                .then((value) => {
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
    jobsQuery(id) {
        return new Promise((resolve, reject) => {
            this.queries
                .getJobs(id)
                .then((value) => {
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
    openWorkflowInstanceDetails(id) {
        this._WorkflowDetailsState = { id: id };
        this.listeners.forEach((listener) => listener.onOpen(id));
        return Promise.resolve();
    }
    onOpenWorkflowInstanceDetailsListener(listener) {
        this.listeners.push(listener);
        const unSubscribe = () => {
            const index = this.listeners.indexOf(listener);
            if (index > -1) {
                this.listeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
    handleWorkflowRetry(workflowInstance) {
        return this.queries.handleWorkflowRetry(workflowInstance);
    }
    handleNodeInstanceCancel(workflowInstance, node) {
        return this.queries.handleNodeInstanceCancel(workflowInstance, node);
    }
    handleWorkflowSkip(workflowInstance) {
        return this.queries.handleWorkflowSkip(workflowInstance);
    }
    handleNodeInstanceRetrigger(workflowInstance, node) {
        return this.queries.handleNodeInstanceRetrigger(workflowInstance, node);
    }
}
//# sourceMappingURL=WorkflowDetailsGatewayApi.js.map