import { getChildWorkflowInstances, getWorkflowInstances, handleWorkflowAbort, handleWorkflowMultipleAction, handleWorkflowRetry, handleWorkflowSkip, } from "@kie-tools/runtime-tools-swf-gateway-api/dist/gatewayApi";
export class GraphQLWorkflowListQueries {
    constructor(client) {
        this.client = client;
    }
    getWorkflowInstances(offset, limit, filters, sortBy) {
        return getWorkflowInstances(offset, limit, filters, sortBy, this.client);
    }
    getChildWorkflowInstances(rootWorkflowInstanceId) {
        return getChildWorkflowInstances(rootWorkflowInstanceId, this.client);
    }
    async handleWorkflowSkip(workflowInstance) {
        return handleWorkflowSkip(workflowInstance, this.client);
    }
    async handleWorkflowAbort(workflowInstance) {
        return handleWorkflowAbort(workflowInstance, this.client);
    }
    async handleWorkflowRetry(workflowInstance) {
        return handleWorkflowRetry(workflowInstance, this.client);
    }
    async handleWorkflowMultipleAction(workflowInstances, operationType) {
        return handleWorkflowMultipleAction(workflowInstances, operationType, this.client);
    }
}
//# sourceMappingURL=WorkflowListQueries.js.map