import { By } from "selenium-webdriver";
import PageFragment from "../PageFragment";
class Explorer extends PageFragment {
    async waitUntilLoaded() {
        return await this.tools.by(Explorer.PANEL_LOCATOR).wait(5000).untilPresent();
    }
    async getItems() {
        return await this.tools.by(Explorer.ITEM_LOCATOR).getElements();
    }
    async getNodes() {
        const items = await this.getItems();
        items.shift();
        return items;
    }
    async getNode(name) {
        for (const node of await this.getNodes()) {
            if ((await node.getText()) === name) {
                return node;
            }
        }
        throw new Error("Node '" + name + "' was not found.");
    }
    async getProcessName() {
        const items = await this.getItems();
        return await items[0].getText();
    }
    async getNodeNames() {
        const nodes = await this.getNodes();
        return Promise.all(nodes.map((node) => node.getText()));
    }
    async selectNode(name) {
        const node = await this.getNode(name);
        return await node.click();
    }
}
Explorer.PANEL_LOCATOR = By.xpath("//div[@data-field='explorerPanelBody']");
Explorer.ITEM_LOCATOR = By.className("gwt-Anchor");
export default Explorer;
//# sourceMappingURL=Explorer.js.map