import { By } from "selenium-webdriver";
import PageFragment from "../../PageFragment";
class DmnPalette extends PageFragment {
    async waitUntilLoaded() {
        return await this.tools.by(DmnPalette.ANNOTATION_LOCATOR).wait(1000).untilPresent();
    }
    async dragAndDropAnnotationToCanvas() {
        const annotation = await this.tools.by(DmnPalette.ANNOTATION_LOCATOR).getElement();
        await annotation.dragAndDrop(200, 0);
        return await annotation.offsetClick(100, 0);
    }
}
DmnPalette.ANNOTATION_LOCATOR = By.xpath("//button[@title='DMN Text Annotation']");
export default DmnPalette;
//# sourceMappingURL=DmnPalette.js.map