import { Form } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
export interface FormDisplayerInitArgs {
    form: Form;
    data?: any;
    context?: Record<string, any>;
}
export type FormSubmitContext = {
    params?: Record<string, string>;
};
export declare enum FormOpenedState {
    OPENED = "opened",
    ERROR = "error"
}
export type FormOpened = {
    state: FormOpenedState;
    size: FormSize;
};
export type FormSize = {
    width: number;
    height: number;
};
export declare enum FormSubmitResponseType {
    SUCCESS = "success",
    FAILURE = "failure"
}
export type FormSubmitResponse = {
    type: FormSubmitResponseType;
    info: any;
};
export interface Association {
    origin: string;
    envelopeServerId: string;
}
//# sourceMappingURL=types.d.ts.map